/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModification;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesModificationsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeReservedInstancesModificationsResponse> {
    private final String nextToken;
    private final List<ReservedInstancesModification> reservedInstancesModifications;

    private DescribeReservedInstancesModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstancesModifications = builder.reservedInstancesModifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ReservedInstancesModification> reservedInstancesModifications() {
        return this.reservedInstancesModifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesModifications());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsResponse)) {
            return false;
        }
        DescribeReservedInstancesModificationsResponse other = (DescribeReservedInstancesModificationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.reservedInstancesModifications(), other.reservedInstancesModifications());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedInstancesModificationsResponse").add("NextToken", (Object)this.nextToken()).add("ReservedInstancesModifications", this.reservedInstancesModifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ReservedInstancesModifications": {
                return Optional.of(clazz.cast(this.reservedInstancesModifications()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedInstancesModification> reservedInstancesModifications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsResponse model) {
            this.nextToken(model.nextToken);
            this.reservedInstancesModifications(model.reservedInstancesModifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ReservedInstancesModification.Builder> getReservedInstancesModifications() {
            return this.reservedInstancesModifications != null ? (Collection)this.reservedInstancesModifications.stream().map(ReservedInstancesModification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesModifications(Collection<ReservedInstancesModification> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier.copy(reservedInstancesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModifications(ReservedInstancesModification ... reservedInstancesModifications) {
            this.reservedInstancesModifications(Arrays.asList(reservedInstancesModifications));
            return this;
        }

        public final void setReservedInstancesModifications(Collection<ReservedInstancesModification.BuilderImpl> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier.copyFromBuilder(reservedInstancesModifications);
        }

        @Override
        public DescribeReservedInstancesModificationsResponse build() {
            return new DescribeReservedInstancesModificationsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeReservedInstancesModificationsResponse> {
        public Builder nextToken(String var1);

        public Builder reservedInstancesModifications(Collection<ReservedInstancesModification> var1);

        public Builder reservedInstancesModifications(ReservedInstancesModification ... var1);
    }
}

