/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItem;
import software.amazon.awssdk.services.ec2.model.UnsuccessfulItemSetCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFlowLogsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, CreateFlowLogsResponse> {
    private final String clientToken;
    private final List<String> flowLogIds;
    private final List<UnsuccessfulItem> unsuccessful;

    private CreateFlowLogsResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.flowLogIds = builder.flowLogIds;
        this.unsuccessful = builder.unsuccessful;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<String> flowLogIds() {
        return this.flowLogIds;
    }

    public List<UnsuccessfulItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsuccessful());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsResponse)) {
            return false;
        }
        CreateFlowLogsResponse other = (CreateFlowLogsResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.flowLogIds(), other.flowLogIds()) && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public String toString() {
        return ToString.builder((String)"CreateFlowLogsResponse").add("ClientToken", (Object)this.clientToken()).add("FlowLogIds", this.flowLogIds()).add("Unsuccessful", this.unsuccessful()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "FlowLogIds": {
                return Optional.of(clazz.cast(this.flowLogIds()));
            }
            case "Unsuccessful": {
                return Optional.of(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String clientToken;
        private List<String> flowLogIds;
        private List<UnsuccessfulItem> unsuccessful;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsResponse model) {
            this.clientToken(model.clientToken);
            this.flowLogIds(model.flowLogIds);
            this.unsuccessful(model.unsuccessful);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<String> getFlowLogIds() {
            return this.flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String ... flowLogIds) {
            this.flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        public final Collection<UnsuccessfulItem.Builder> getUnsuccessful() {
            return this.unsuccessful != null ? (Collection)this.unsuccessful.stream().map(UnsuccessfulItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public CreateFlowLogsResponse build() {
            return new CreateFlowLogsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, CreateFlowLogsResponse> {
        public Builder clientToken(String var1);

        public Builder flowLogIds(Collection<String> var1);

        public Builder flowLogIds(String ... var1);

        public Builder unsuccessful(Collection<UnsuccessfulItem> var1);

        public Builder unsuccessful(UnsuccessfulItem ... var1);
    }
}

