/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelImportTaskRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CancelImportTaskRequest> {
    private final String cancelReason;
    private final String importTaskId;

    private CancelImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cancelReason = builder.cancelReason;
        this.importTaskId = builder.importTaskId;
    }

    public String cancelReason() {
        return this.cancelReason;
    }

    public String importTaskId() {
        return this.importTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskRequest)) {
            return false;
        }
        CancelImportTaskRequest other = (CancelImportTaskRequest)((Object)obj);
        return Objects.equals(this.cancelReason(), other.cancelReason()) && Objects.equals(this.importTaskId(), other.importTaskId());
    }

    public String toString() {
        return ToString.builder((String)"CancelImportTaskRequest").add("CancelReason", (Object)this.cancelReason()).add("ImportTaskId", (Object)this.importTaskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CancelReason": {
                return Optional.of(clazz.cast(this.cancelReason()));
            }
            case "ImportTaskId": {
                return Optional.of(clazz.cast(this.importTaskId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String cancelReason;
        private String importTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskRequest model) {
            this.cancelReason(model.cancelReason);
            this.importTaskId(model.importTaskId);
        }

        public final String getCancelReason() {
            return this.cancelReason;
        }

        @Override
        public final Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public final void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelImportTaskRequest build() {
            return new CancelImportTaskRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CancelImportTaskRequest> {
        public Builder cancelReason(String var1);

        public Builder importTaskId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

