/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessage;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneMessageListCopier;
import software.amazon.awssdk.services.ec2.model.AvailabilityZoneState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AvailabilityZone
implements ToCopyableBuilder<Builder, AvailabilityZone> {
    private final String state;
    private final List<AvailabilityZoneMessage> messages;
    private final String regionName;
    private final String zoneName;

    private AvailabilityZone(BuilderImpl builder) {
        this.state = builder.state;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
    }

    public AvailabilityZoneState state() {
        return AvailabilityZoneState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public List<AvailabilityZoneMessage> messages() {
        return this.messages;
    }

    public String regionName() {
        return this.regionName;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        return Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.zoneName(), other.zoneName());
    }

    public String toString() {
        return ToString.builder((String)"AvailabilityZone").add("State", (Object)this.stateString()).add("Messages", this.messages()).add("RegionName", (Object)this.regionName()).add("ZoneName", (Object)this.zoneName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "Messages": {
                return Optional.of(clazz.cast(this.messages()));
            }
            case "RegionName": {
                return Optional.of(clazz.cast(this.regionName()));
            }
            case "ZoneName": {
                return Optional.of(clazz.cast(this.zoneName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private List<AvailabilityZoneMessage> messages;
        private String regionName;
        private String zoneName;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.state(model.state);
            this.messages(model.messages);
            this.regionName(model.regionName);
            this.zoneName(model.zoneName);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<AvailabilityZoneMessage.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(AvailabilityZoneMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage.BuilderImpl> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copyFromBuilder(messages);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AvailabilityZone> {
        public Builder state(String var1);

        public Builder state(AvailabilityZoneState var1);

        public Builder messages(Collection<AvailabilityZoneMessage> var1);

        public Builder messages(AvailabilityZoneMessage ... var1);

        public Builder regionName(String var1);

        public Builder zoneName(String var1);
    }
}

