/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.VgwTelemetry;
import software.amazon.awssdk.services.ec2.model.VpnConnection;
import software.amazon.awssdk.services.ec2.model.VpnStaticRoute;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VgwTelemetryUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpnConnectionOptionsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpnStaticRouteUnmarshaller;

public class VpnConnectionUnmarshaller
implements Unmarshaller<VpnConnection, StaxUnmarshallerContext> {
    private static final VpnConnectionUnmarshaller INSTANCE = new VpnConnectionUnmarshaller();

    public VpnConnection unmarshall(StaxUnmarshallerContext context) throws Exception {
        VpnConnection.Builder vpnConnection;
        block16: {
            vpnConnection = VpnConnection.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<VpnStaticRoute> routes = null;
            ArrayList<Tag> tags = null;
            ArrayList<VgwTelemetry> vgwTelemetry = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    vpnConnection.routes(routes);
                    vpnConnection.tags(tags);
                    vpnConnection.vgwTelemetry(vgwTelemetry);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("customerGatewayConfiguration", targetDepth)) {
                        vpnConnection.customerGatewayConfiguration(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("customerGatewayId", targetDepth)) {
                        vpnConnection.customerGatewayId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        vpnConnection.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("type", targetDepth)) {
                        vpnConnection.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpnConnectionId", targetDepth)) {
                        vpnConnection.vpnConnectionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpnGatewayId", targetDepth)) {
                        vpnConnection.vpnGatewayId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("options", targetDepth)) {
                        vpnConnection.options(VpnConnectionOptionsUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("routes", targetDepth)) {
                        routes = new ArrayList<VpnStaticRoute>();
                        continue;
                    }
                    if (context.testExpression("routes/item", targetDepth)) {
                        routes.add(VpnStaticRouteUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vgwTelemetry", targetDepth)) {
                        vgwTelemetry = new ArrayList<VgwTelemetry>();
                        continue;
                    }
                    if (!context.testExpression("vgwTelemetry/item", targetDepth)) continue;
                    vgwTelemetry.add(VgwTelemetryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            vpnConnection.routes(routes);
            vpnConnection.tags(tags);
            vpnConnection.vgwTelemetry(vgwTelemetry);
        }
        return (VpnConnection)vpnConnection.build();
    }

    public static VpnConnectionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

