/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ReleaseAddressRequest;
import software.amazon.awssdk.util.StringUtils;

public class ReleaseAddressRequestMarshaller
implements Marshaller<Request<ReleaseAddressRequest>, ReleaseAddressRequest> {
    public Request<ReleaseAddressRequest> marshall(ReleaseAddressRequest releaseAddressRequest) {
        if (releaseAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)releaseAddressRequest, "EC2Client");
        request.addParameter("Action", "ReleaseAddress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (releaseAddressRequest.allocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)releaseAddressRequest.allocationId()));
        }
        if (releaseAddressRequest.publicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)releaseAddressRequest.publicIp()));
        }
        return request;
    }
}

