/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.IamInstanceProfileSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceNetworkInterfaceSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SpotPlacementUnmarshaller;

public class LaunchSpecificationUnmarshaller
implements Unmarshaller<LaunchSpecification, StaxUnmarshallerContext> {
    private static final LaunchSpecificationUnmarshaller INSTANCE = new LaunchSpecificationUnmarshaller();

    public LaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchSpecification.Builder launchSpecification;
        block23: {
            launchSpecification = LaunchSpecification.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<BlockDeviceMapping> blockDeviceMappings = null;
            ArrayList<InstanceNetworkInterfaceSpecification> networkInterfaces = null;
            ArrayList<GroupIdentifier> allSecurityGroups = null;
            ArrayList<String> securityGroups = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    launchSpecification.blockDeviceMappings(blockDeviceMappings);
                    launchSpecification.networkInterfaces(networkInterfaces);
                    launchSpecification.allSecurityGroups(allSecurityGroups);
                    launchSpecification.securityGroups(securityGroups);
                    break block23;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("userData", targetDepth)) {
                        launchSpecification.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("addressingType", targetDepth)) {
                        launchSpecification.addressingType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping", targetDepth)) {
                        blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                        blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ebsOptimized", targetDepth)) {
                        launchSpecification.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("iamInstanceProfile", targetDepth)) {
                        launchSpecification.iamInstanceProfile(IamInstanceProfileSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageId", targetDepth)) {
                        launchSpecification.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceType", targetDepth)) {
                        launchSpecification.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("kernelId", targetDepth)) {
                        launchSpecification.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("keyName", targetDepth)) {
                        launchSpecification.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkInterfaceSet", targetDepth)) {
                        networkInterfaces = new ArrayList<InstanceNetworkInterfaceSpecification>();
                        continue;
                    }
                    if (context.testExpression("networkInterfaceSet/item", targetDepth)) {
                        networkInterfaces.add(InstanceNetworkInterfaceSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("placement", targetDepth)) {
                        launchSpecification.placement(SpotPlacementUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ramdiskId", targetDepth)) {
                        launchSpecification.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("subnetId", targetDepth)) {
                        launchSpecification.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupSet", targetDepth)) {
                        allSecurityGroups = new ArrayList<GroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        allSecurityGroups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("monitoring/enabled", targetDepth)) {
                        launchSpecification.monitoringEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("securityGroup", targetDepth)) {
                        securityGroups = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("securityGroup/GroupName", targetDepth)) continue;
                    securityGroups.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            launchSpecification.blockDeviceMappings(blockDeviceMappings);
            launchSpecification.networkInterfaces(networkInterfaces);
            launchSpecification.allSecurityGroups(allSecurityGroups);
            launchSpecification.securityGroups(securityGroups);
        }
        return (LaunchSpecification)launchSpecification.build();
    }

    public static LaunchSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

