/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetConsoleScreenshotRequestMarshaller
implements Marshaller<Request<GetConsoleScreenshotRequest>, GetConsoleScreenshotRequest> {
    public Request<GetConsoleScreenshotRequest> marshall(GetConsoleScreenshotRequest getConsoleScreenshotRequest) {
        if (getConsoleScreenshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getConsoleScreenshotRequest, "EC2Client");
        request.addParameter("Action", "GetConsoleScreenshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getConsoleScreenshotRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)getConsoleScreenshotRequest.instanceId()));
        }
        if (getConsoleScreenshotRequest.wakeUp() != null) {
            request.addParameter("WakeUp", StringUtils.fromBoolean((Boolean)getConsoleScreenshotRequest.wakeUp()));
        }
        return request;
    }
}

