/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeInstanceAttributeRequestMarshaller
implements Marshaller<Request<DescribeInstanceAttributeRequest>, DescribeInstanceAttributeRequest> {
    public Request<DescribeInstanceAttributeRequest> marshall(DescribeInstanceAttributeRequest describeInstanceAttributeRequest) {
        if (describeInstanceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeInstanceAttributeRequest.attribute()));
        }
        if (describeInstanceAttributeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)describeInstanceAttributeRequest.instanceId()));
        }
        return request;
    }
}

