/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcAttachment
implements ToCopyableBuilder<Builder, VpcAttachment> {
    private final String state;
    private final String vpcId;

    private VpcAttachment(BuilderImpl builder) {
        this.state = builder.state;
        this.vpcId = builder.vpcId;
    }

    public String state() {
        return this.state;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcAttachment)) {
            return false;
        }
        VpcAttachment other = (VpcAttachment)obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String state;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcAttachment model) {
            this.setState(model.state);
            this.setVpcId(model.vpcId);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AttachmentStatus state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public VpcAttachment build() {
            return new VpcAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcAttachment> {
        public Builder state(String var1);

        public Builder state(AttachmentStatus var1);

        public Builder vpcId(String var1);
    }
}

