/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StopInstancesRequest> {
    private final List<String> instanceIds;
    private final Boolean force;

    private StopInstancesRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.force = builder.force;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Boolean force() {
        return this.force;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        hashCode = 31 * hashCode + (this.force() == null ? 0 : this.force().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesRequest)) {
            return false;
        }
        StopInstancesRequest other = (StopInstancesRequest)((Object)obj);
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.force() == null ^ this.force() == null) {
            return false;
        }
        return other.force() == null || other.force().equals(this.force());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.force() != null) {
            sb.append("Force: ").append(this.force()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesRequest model) {
            this.setInstanceIds(model.instanceIds);
            this.setForce(model.force);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public StopInstancesRequest build() {
            return new StopInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StopInstancesRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder force(Boolean var1);
    }
}

