/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.PaymentOption;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Purchase
implements ToCopyableBuilder<Builder, Purchase> {
    private final String currencyCode;
    private final Integer duration;
    private final List<String> hostIdSet;
    private final String hostReservationId;
    private final String hourlyPrice;
    private final String instanceFamily;
    private final String paymentOption;
    private final String upfrontPrice;

    private Purchase(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.paymentOption = builder.paymentOption;
        this.upfrontPrice = builder.upfrontPrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Integer duration() {
        return this.duration;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String hostReservationId() {
        return this.hostReservationId;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String instanceFamily() {
        return this.instanceFamily;
    }

    public String paymentOption() {
        return this.paymentOption;
    }

    public String upfrontPrice() {
        return this.upfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.hostIdSet() == null ? 0 : this.hostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.hostReservationId() == null ? 0 : this.hostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.hourlyPrice() == null ? 0 : this.hourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceFamily() == null ? 0 : this.instanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.paymentOption() == null ? 0 : this.paymentOption().hashCode());
        hashCode = 31 * hashCode + (this.upfrontPrice() == null ? 0 : this.upfrontPrice().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Purchase)) {
            return false;
        }
        Purchase other = (Purchase)obj;
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.hostIdSet() == null ^ this.hostIdSet() == null) {
            return false;
        }
        if (other.hostIdSet() != null && !other.hostIdSet().equals(this.hostIdSet())) {
            return false;
        }
        if (other.hostReservationId() == null ^ this.hostReservationId() == null) {
            return false;
        }
        if (other.hostReservationId() != null && !other.hostReservationId().equals(this.hostReservationId())) {
            return false;
        }
        if (other.hourlyPrice() == null ^ this.hourlyPrice() == null) {
            return false;
        }
        if (other.hourlyPrice() != null && !other.hourlyPrice().equals(this.hourlyPrice())) {
            return false;
        }
        if (other.instanceFamily() == null ^ this.instanceFamily() == null) {
            return false;
        }
        if (other.instanceFamily() != null && !other.instanceFamily().equals(this.instanceFamily())) {
            return false;
        }
        if (other.paymentOption() == null ^ this.paymentOption() == null) {
            return false;
        }
        if (other.paymentOption() != null && !other.paymentOption().equals(this.paymentOption())) {
            return false;
        }
        if (other.upfrontPrice() == null ^ this.upfrontPrice() == null) {
            return false;
        }
        return other.upfrontPrice() == null || other.upfrontPrice().equals(this.upfrontPrice());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.hostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.hostIdSet()).append(",");
        }
        if (this.hostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.hostReservationId()).append(",");
        }
        if (this.hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(this.hourlyPrice()).append(",");
        }
        if (this.instanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.instanceFamily()).append(",");
        }
        if (this.paymentOption() != null) {
            sb.append("PaymentOption: ").append(this.paymentOption()).append(",");
        }
        if (this.upfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(this.upfrontPrice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private Integer duration;
        private List<String> hostIdSet;
        private String hostReservationId;
        private String hourlyPrice;
        private String instanceFamily;
        private String paymentOption;
        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(Purchase model) {
            this.setCurrencyCode(model.currencyCode);
            this.setDuration(model.duration);
            this.setHostIdSet(model.hostIdSet);
            this.setHostReservationId(model.hostReservationId);
            this.setHourlyPrice(model.hourlyPrice);
            this.setInstanceFamily(model.instanceFamily);
            this.setPaymentOption(model.paymentOption);
            this.setUpfrontPrice(model.upfrontPrice);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getUpfrontPrice() {
            return this.upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        public Purchase build() {
            return new Purchase(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Purchase> {
        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder duration(Integer var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder hostReservationId(String var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceFamily(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder upfrontPrice(String var1);
    }
}

