/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfiguration;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesConfigurationListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyReservedInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyReservedInstancesRequest> {
    private final List<String> reservedInstancesIds;
    private final String clientToken;
    private final List<ReservedInstancesConfiguration> targetConfigurations;

    private ModifyReservedInstancesRequest(BuilderImpl builder) {
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.clientToken = builder.clientToken;
        this.targetConfigurations = builder.targetConfigurations;
    }

    public List<String> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public List<ReservedInstancesConfiguration> targetConfigurations() {
        return this.targetConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedInstancesIds() == null ? 0 : this.reservedInstancesIds().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.targetConfigurations() == null ? 0 : this.targetConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest)((Object)obj);
        if (other.reservedInstancesIds() == null ^ this.reservedInstancesIds() == null) {
            return false;
        }
        if (other.reservedInstancesIds() != null && !other.reservedInstancesIds().equals(this.reservedInstancesIds())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.targetConfigurations() == null ^ this.targetConfigurations() == null) {
            return false;
        }
        return other.targetConfigurations() == null || other.targetConfigurations().equals(this.targetConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(this.reservedInstancesIds()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.targetConfigurations() != null) {
            sb.append("TargetConfigurations: ").append(this.targetConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> reservedInstancesIds;
        private String clientToken;
        private List<ReservedInstancesConfiguration> targetConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReservedInstancesRequest model) {
            this.setReservedInstancesIds(model.reservedInstancesIds);
            this.setClientToken(model.clientToken);
            this.setTargetConfigurations(model.targetConfigurations);
        }

        public final Collection<String> getReservedInstancesIds() {
            return this.reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(String ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        public final void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedInstancesIdStringListCopier.copy(reservedInstancesIds);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<ReservedInstancesConfiguration> getTargetConfigurations() {
            return this.targetConfigurations;
        }

        @Override
        public final Builder targetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copy(targetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetConfigurations(ReservedInstancesConfiguration ... targetConfigurations) {
            this.targetConfigurations(Arrays.asList(targetConfigurations));
            return this;
        }

        public final void setTargetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
            this.targetConfigurations = ReservedInstancesConfigurationListCopier.copy(targetConfigurations);
        }

        public ModifyReservedInstancesRequest build() {
            return new ModifyReservedInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyReservedInstancesRequest> {
        public Builder reservedInstancesIds(Collection<String> var1);

        public Builder reservedInstancesIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder targetConfigurations(Collection<ReservedInstancesConfiguration> var1);

        public Builder targetConfigurations(ReservedInstancesConfiguration ... var1);
    }
}

