/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.Monitoring;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceMonitoring
implements ToCopyableBuilder<Builder, InstanceMonitoring> {
    private final String instanceId;
    private final Monitoring monitoring;

    private InstanceMonitoring(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.monitoring = builder.monitoring;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Monitoring monitoring() {
        return this.monitoring;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.monitoring() == null ? 0 : this.monitoring().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMonitoring)) {
            return false;
        }
        InstanceMonitoring other = (InstanceMonitoring)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        return other.monitoring() == null || other.monitoring().equals(this.monitoring());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.monitoring() != null) {
            sb.append("Monitoring: ").append(this.monitoring()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private Monitoring monitoring;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMonitoring model) {
            this.setInstanceId(model.instanceId);
            this.setMonitoring(model.monitoring);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Monitoring getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
        }

        public InstanceMonitoring build() {
            return new InstanceMonitoring(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceMonitoring> {
        public Builder instanceId(String var1);

        public Builder monitoring(Monitoring var1);
    }
}

