/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermission;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotAttributeResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
    private final List<CreateVolumePermission> createVolumePermissions;
    private final List<ProductCode> productCodes;
    private final String snapshotId;

    private DescribeSnapshotAttributeResponse(BuilderImpl builder) {
        this.createVolumePermissions = builder.createVolumePermissions;
        this.productCodes = builder.productCodes;
        this.snapshotId = builder.snapshotId;
    }

    public List<CreateVolumePermission> createVolumePermissions() {
        return this.createVolumePermissions;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createVolumePermissions() == null ? 0 : this.createVolumePermissions().hashCode());
        hashCode = 31 * hashCode + (this.productCodes() == null ? 0 : this.productCodes().hashCode());
        hashCode = 31 * hashCode + (this.snapshotId() == null ? 0 : this.snapshotId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotAttributeResponse)) {
            return false;
        }
        DescribeSnapshotAttributeResponse other = (DescribeSnapshotAttributeResponse)((Object)obj);
        if (other.createVolumePermissions() == null ^ this.createVolumePermissions() == null) {
            return false;
        }
        if (other.createVolumePermissions() != null && !other.createVolumePermissions().equals(this.createVolumePermissions())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.snapshotId() == null ^ this.snapshotId() == null) {
            return false;
        }
        return other.snapshotId() == null || other.snapshotId().equals(this.snapshotId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createVolumePermissions() != null) {
            sb.append("CreateVolumePermissions: ").append(this.createVolumePermissions()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<CreateVolumePermission> createVolumePermissions;
        private List<ProductCode> productCodes;
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotAttributeResponse model) {
            this.setCreateVolumePermissions(model.createVolumePermissions);
            this.setProductCodes(model.productCodes);
            this.setSnapshotId(model.snapshotId);
        }

        public final Collection<CreateVolumePermission> getCreateVolumePermissions() {
            return this.createVolumePermissions;
        }

        @Override
        public final Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(CreateVolumePermission ... createVolumePermissions) {
            this.createVolumePermissions(Arrays.asList(createVolumePermissions));
            return this;
        }

        public final void setCreateVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
        }

        public final Collection<ProductCode> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public DescribeSnapshotAttributeResponse build() {
            return new DescribeSnapshotAttributeResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
        public Builder createVolumePermissions(Collection<CreateVolumePermission> var1);

        public Builder createVolumePermissions(CreateVolumePermission ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder snapshotId(String var1);
    }
}

