/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceIdRequestSetCopier;
import software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeScheduledInstancesRequest> {
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> scheduledInstanceIds;
    private final SlotStartTimeRangeRequest slotStartTimeRange;

    private DescribeScheduledInstancesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scheduledInstanceIds = builder.scheduledInstanceIds;
        this.slotStartTimeRange = builder.slotStartTimeRange;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> scheduledInstanceIds() {
        return this.scheduledInstanceIds;
    }

    public SlotStartTimeRangeRequest slotStartTimeRange() {
        return this.slotStartTimeRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.scheduledInstanceIds() == null ? 0 : this.scheduledInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.slotStartTimeRange() == null ? 0 : this.slotStartTimeRange().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesRequest)) {
            return false;
        }
        DescribeScheduledInstancesRequest other = (DescribeScheduledInstancesRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.scheduledInstanceIds() == null ^ this.scheduledInstanceIds() == null) {
            return false;
        }
        if (other.scheduledInstanceIds() != null && !other.scheduledInstanceIds().equals(this.scheduledInstanceIds())) {
            return false;
        }
        if (other.slotStartTimeRange() == null ^ this.slotStartTimeRange() == null) {
            return false;
        }
        return other.slotStartTimeRange() == null || other.slotStartTimeRange().equals(this.slotStartTimeRange());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.scheduledInstanceIds() != null) {
            sb.append("ScheduledInstanceIds: ").append(this.scheduledInstanceIds()).append(",");
        }
        if (this.slotStartTimeRange() != null) {
            sb.append("SlotStartTimeRange: ").append(this.slotStartTimeRange()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private Integer maxResults;
        private String nextToken;
        private List<String> scheduledInstanceIds;
        private SlotStartTimeRangeRequest slotStartTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesRequest model) {
            this.setFilters(model.filters);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setScheduledInstanceIds(model.scheduledInstanceIds);
            this.setSlotStartTimeRange(model.slotStartTimeRange);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getScheduledInstanceIds() {
            return this.scheduledInstanceIds;
        }

        @Override
        public final Builder scheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceIds(String ... scheduledInstanceIds) {
            this.scheduledInstanceIds(Arrays.asList(scheduledInstanceIds));
            return this;
        }

        public final void setScheduledInstanceIds(Collection<String> scheduledInstanceIds) {
            this.scheduledInstanceIds = ScheduledInstanceIdRequestSetCopier.copy(scheduledInstanceIds);
        }

        public final SlotStartTimeRangeRequest getSlotStartTimeRange() {
            return this.slotStartTimeRange;
        }

        @Override
        public final Builder slotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange;
            return this;
        }

        public final void setSlotStartTimeRange(SlotStartTimeRangeRequest slotStartTimeRange) {
            this.slotStartTimeRange = slotStartTimeRange;
        }

        public DescribeScheduledInstancesRequest build() {
            return new DescribeScheduledInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledInstancesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder scheduledInstanceIds(Collection<String> var1);

        public Builder scheduledInstanceIds(String ... var1);

        public Builder slotStartTimeRange(SlotStartTimeRangeRequest var1);
    }
}

