/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ebs.model.ChecksumAlgorithm;
import software.amazon.awssdk.services.ebs.model.EbsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSnapshotBlockResponse
extends EbsResponse
implements ToCopyableBuilder<Builder, PutSnapshotBlockResponse> {
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Checksum").getter(PutSnapshotBlockResponse.getter(PutSnapshotBlockResponse::checksum)).setter(PutSnapshotBlockResponse.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum").build()}).build();
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(PutSnapshotBlockResponse.getter(PutSnapshotBlockResponse::checksumAlgorithmAsString)).setter(PutSnapshotBlockResponse.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum-Algorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutSnapshotBlockResponse.memberNameToFieldInitializer();
    private final String checksum;
    private final String checksumAlgorithm;

    private PutSnapshotBlockResponse(BuilderImpl builder) {
        super(builder);
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final ChecksumAlgorithm checksumAlgorithm() {
        return ChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSnapshotBlockResponse)) {
            return false;
        }
        PutSnapshotBlockResponse other = (PutSnapshotBlockResponse)((Object)obj);
        return Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutSnapshotBlockResponse").add("Checksum", (Object)this.checksum()).add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("x-amz-Checksum", CHECKSUM_FIELD);
        map.put("x-amz-Checksum-Algorithm", CHECKSUM_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSnapshotBlockResponse, T> g) {
        return obj -> g.apply((PutSnapshotBlockResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EbsResponse.BuilderImpl
    implements Builder {
        private String checksum;
        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSnapshotBlockResponse model) {
            super(model);
            this.checksum(model.checksum);
            this.checksumAlgorithm(model.checksumAlgorithm);
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        @Override
        public PutSnapshotBlockResponse build() {
            return new PutSnapshotBlockResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EbsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSnapshotBlockResponse> {
        public Builder checksum(String var1);

        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(ChecksumAlgorithm var1);
    }
}

