/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSnapshotBlocksRequest extends EbsRequest implements
        ToCopyableBuilder<ListSnapshotBlocksRequest.Builder, ListSnapshotBlocksRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(ListSnapshotBlocksRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSnapshotBlocksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSnapshotBlocksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<Integer> STARTING_BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartingBlockIndex").getter(getter(ListSnapshotBlocksRequest::startingBlockIndex))
            .setter(setter(Builder::startingBlockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingBlockIndex").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STARTING_BLOCK_INDEX_FIELD));

    private final String snapshotId;

    private final String nextToken;

    private final Integer maxResults;

    private final Integer startingBlockIndex;

    private ListSnapshotBlocksRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startingBlockIndex = builder.startingBlockIndex;
    }

    /**
     * <p>
     * The ID of the snapshot from which to get block indexes and block tokens.
     * </p>
     * 
     * @return The ID of the snapshot from which to get block indexes and block tokens.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The number of results to return.
     * </p>
     * 
     * @return The number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The block index from which the list should start. The list in the response will start from this block index or
     * the next valid block index in the snapshot.
     * </p>
     * 
     * @return The block index from which the list should start. The list in the response will start from this block
     *         index or the next valid block index in the snapshot.
     */
    public final Integer startingBlockIndex() {
        return startingBlockIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(startingBlockIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotBlocksRequest)) {
            return false;
        }
        ListSnapshotBlocksRequest other = (ListSnapshotBlocksRequest) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(startingBlockIndex(), other.startingBlockIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSnapshotBlocksRequest").add("SnapshotId", snapshotId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("StartingBlockIndex", startingBlockIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StartingBlockIndex":
            return Optional.ofNullable(clazz.cast(startingBlockIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotBlocksRequest, T> g) {
        return obj -> g.apply((ListSnapshotBlocksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSnapshotBlocksRequest> {
        /**
         * <p>
         * The ID of the snapshot from which to get block indexes and block tokens.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot from which to get block indexes and block tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The block index from which the list should start. The list in the response will start from this block index
         * or the next valid block index in the snapshot.
         * </p>
         * 
         * @param startingBlockIndex
         *        The block index from which the list should start. The list in the response will start from this block
         *        index or the next valid block index in the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingBlockIndex(Integer startingBlockIndex);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EbsRequest.BuilderImpl implements Builder {
        private String snapshotId;

        private String nextToken;

        private Integer maxResults;

        private Integer startingBlockIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotBlocksRequest model) {
            super(model);
            snapshotId(model.snapshotId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            startingBlockIndex(model.startingBlockIndex);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getStartingBlockIndex() {
            return startingBlockIndex;
        }

        @Override
        public final Builder startingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
            return this;
        }

        public final void setStartingBlockIndex(Integer startingBlockIndex) {
            this.startingBlockIndex = startingBlockIndex;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSnapshotBlocksRequest build() {
            return new ListSnapshotBlocksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
