/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SequenceNumberRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SequenceNumberRange> {
    private static final SdkField<String> STARTING_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SequenceNumberRange.getter(SequenceNumberRange::startingSequenceNumber)).setter(SequenceNumberRange.setter(Builder::startingSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingSequenceNumber").build()}).build();
    private static final SdkField<String> ENDING_SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SequenceNumberRange.getter(SequenceNumberRange::endingSequenceNumber)).setter(SequenceNumberRange.setter(Builder::endingSequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndingSequenceNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTING_SEQUENCE_NUMBER_FIELD, ENDING_SEQUENCE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String startingSequenceNumber;
    private final String endingSequenceNumber;

    private SequenceNumberRange(BuilderImpl builder) {
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.endingSequenceNumber = builder.endingSequenceNumber;
    }

    public String startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public String endingSequenceNumber() {
        return this.endingSequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startingSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.endingSequenceNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceNumberRange)) {
            return false;
        }
        SequenceNumberRange other = (SequenceNumberRange)obj;
        return Objects.equals(this.startingSequenceNumber(), other.startingSequenceNumber()) && Objects.equals(this.endingSequenceNumber(), other.endingSequenceNumber());
    }

    public String toString() {
        return ToString.builder((String)"SequenceNumberRange").add("StartingSequenceNumber", (Object)this.startingSequenceNumber()).add("EndingSequenceNumber", (Object)this.endingSequenceNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartingSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.startingSequenceNumber()));
            }
            case "EndingSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.endingSequenceNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SequenceNumberRange, T> g) {
        return obj -> g.apply((SequenceNumberRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String startingSequenceNumber;
        private String endingSequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceNumberRange model) {
            this.startingSequenceNumber(model.startingSequenceNumber);
            this.endingSequenceNumber(model.endingSequenceNumber);
        }

        public final String getStartingSequenceNumber() {
            return this.startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final String getEndingSequenceNumber() {
            return this.endingSequenceNumber;
        }

        @Override
        public final Builder endingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
            return this;
        }

        public final void setEndingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
        }

        public SequenceNumberRange build() {
            return new SequenceNumberRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SequenceNumberRange> {
        public Builder startingSequenceNumber(String var1);

        public Builder endingSequenceNumber(String var1);
    }
}

