/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the autoscaling policy to be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingPolicyUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingPolicyUpdate.Builder, AutoScalingPolicyUpdate> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoScalingPolicyUpdate::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<AutoScalingTargetTrackingScalingPolicyConfigurationUpdate> TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD = SdkField
            .<AutoScalingTargetTrackingScalingPolicyConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .getter(getter(AutoScalingPolicyUpdate::targetTrackingScalingPolicyConfiguration))
            .setter(setter(Builder::targetTrackingScalingPolicyConfiguration))
            .constructor(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TargetTrackingScalingPolicyConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            TARGET_TRACKING_SCALING_POLICY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration;

    private AutoScalingPolicyUpdate(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
    }

    /**
     * <p>
     * The name of the scaling policy.
     * </p>
     * 
     * @return The name of the scaling policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * Represents a target tracking scaling policy configuration.
     * </p>
     * 
     * @return Represents a target tracking scaling policy configuration.
     */
    public AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration() {
        return targetTrackingScalingPolicyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(targetTrackingScalingPolicyConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyUpdate)) {
            return false;
        }
        AutoScalingPolicyUpdate other = (AutoScalingPolicyUpdate) obj;
        return Objects.equals(policyName(), other.policyName())
                && Objects.equals(targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoScalingPolicyUpdate").add("PolicyName", policyName())
                .add("TargetTrackingScalingPolicyConfiguration", targetTrackingScalingPolicyConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "TargetTrackingScalingPolicyConfiguration":
            return Optional.ofNullable(clazz.cast(targetTrackingScalingPolicyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingPolicyUpdate, T> g) {
        return obj -> g.apply((AutoScalingPolicyUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingPolicyUpdate> {
        /**
         * <p>
         * The name of the scaling policy.
         * </p>
         * 
         * @param policyName
         *        The name of the scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Represents a target tracking scaling policy configuration.
         * </p>
         * 
         * @param targetTrackingScalingPolicyConfiguration
         *        Represents a target tracking scaling policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTrackingScalingPolicyConfiguration(
                AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration);

        /**
         * <p>
         * Represents a target tracking scaling policy configuration.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder} avoiding the need to create one
         * manually via {@link AutoScalingTargetTrackingScalingPolicyConfigurationUpdate#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)}.
         * 
         * @param targetTrackingScalingPolicyConfiguration
         *        a consumer that will call methods on
         *        {@link AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)
         */
        default Builder targetTrackingScalingPolicyConfiguration(
                Consumer<AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder> targetTrackingScalingPolicyConfiguration) {
            return targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.builder()
                    .applyMutation(targetTrackingScalingPolicyConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyUpdate model) {
            policyName(model.policyName);
            targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder getTargetTrackingScalingPolicyConfiguration() {
            return targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(
                AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(
                AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration
                    .build() : null;
        }

        @Override
        public AutoScalingPolicyUpdate build() {
            return new AutoScalingPolicyUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
