/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.dynamodb.DynamoDbServiceClientConfiguration;
import software.amazon.awssdk.services.dynamodb.internal.DynamoDbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.dynamodb.model.BackupInUseException;
import software.amazon.awssdk.services.dynamodb.model.BackupNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DuplicateItemException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ExportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.ImportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ImportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ImportTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ImportTableResponse;
import software.amazon.awssdk.services.dynamodb.model.IndexNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.InvalidExportTimeException;
import software.amazon.awssdk.services.dynamodb.model.InvalidRestoreTimeException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListImportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListImportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.PolicyNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.ReplicaNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ReplicatedWriteConflictException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.TableInUseException;
import software.amazon.awssdk.services.dynamodb.model.TableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.ThrottlingException;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TransactionInProgressException;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.transform.BatchExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchGetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchWriteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeExportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeImportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeLimitsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DisableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.EnableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteTransactionRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExportTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ImportTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListGlobalTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTagsOfResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableFromBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ScanRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactGetItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactWriteItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultDynamoDbAsyncClient
implements DynamoDbAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDynamoDbAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultDynamoDbAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"DynamoDB#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)DynamoDbAsyncEndpointDiscoveryCacheLoader.create(this));
        }
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<BatchExecuteStatementResponse> batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchExecuteStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, batchExecuteStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchExecuteStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchExecuteStatementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchExecuteStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchExecuteStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$batchExecuteStatement$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$batchExecuteStatement$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetItemResponse> batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetItemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = batchGetItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)batchGetItemRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$batchGetItem$7(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, batchGetItemRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$batchGetItem$9(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$batchGetItem$10((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchWriteItemResponse> batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchWriteItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, batchWriteItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchWriteItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchWriteItemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = batchWriteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)batchWriteItemRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$batchWriteItem$14(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, batchWriteItemRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$batchWriteItem$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$batchWriteItem$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBackupResponse> createBackup(CreateBackupRequest createBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, createBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = createBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createBackupRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$createBackup$21(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, createBackupRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$createBackup$23(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$createBackup$24((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGlobalTableResponse> createGlobalTable(CreateGlobalTableRequest createGlobalTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGlobalTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, createGlobalTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGlobalTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGlobalTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = createGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createGlobalTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$createGlobalTable$28(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, createGlobalTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$createGlobalTable$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$createGlobalTable$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, createTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = createTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$createTable$35(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, createTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$createTable$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$createTable$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBackupResponse> deleteBackup(DeleteBackupRequest deleteBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = deleteBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteBackupRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$deleteBackup$42(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, deleteBackupRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$deleteBackup$44(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$deleteBackup$45((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteItemResponse> deleteItem(DeleteItemRequest deleteItemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteItemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = deleteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteItemRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$deleteItem$49(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, deleteItemRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$deleteItem$51(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$deleteItem$52((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = deleteResourcePolicyRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteResourcePolicyRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$deleteResourcePolicy$56(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, deleteResourcePolicyRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$deleteResourcePolicy$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$deleteResourcePolicy$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = deleteTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$deleteTable$63(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, deleteTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$deleteTable$65(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$deleteTable$66((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBackupResponse> describeBackup(DescribeBackupRequest describeBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeBackupRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeBackup$70(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeBackupRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeBackup$72(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeBackup$73((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeContinuousBackupsResponse> describeContinuousBackups(DescribeContinuousBackupsRequest describeContinuousBackupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContinuousBackupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeContinuousBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContinuousBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContinuousBackupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeContinuousBackups$77(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeContinuousBackupsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeContinuousBackups$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeContinuousBackups$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeContributorInsightsResponse> describeContributorInsights(DescribeContributorInsightsRequest describeContributorInsightsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContributorInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContributorInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContributorInsightsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContributorInsights").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeContributorInsightsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeContributorInsights$83(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeContributorInsights$84((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeEndpoints$87(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeEndpoints$88((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeExportResponse> describeExport(DescribeExportRequest describeExportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeExportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeExport$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeExport$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGlobalTableResponse> describeGlobalTable(DescribeGlobalTableRequest describeGlobalTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGlobalTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeGlobalTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeGlobalTable$96(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeGlobalTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTable$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTable$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGlobalTableSettingsResponse> describeGlobalTableSettings(DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGlobalTableSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTableSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeGlobalTableSettings$103(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeGlobalTableSettingsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTableSettings$105(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTableSettings$106((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImportResponse> describeImport(DescribeImportRequest describeImportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeImport$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeImport$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeKinesisStreamingDestinationResponse> describeKinesisStreamingDestination(DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeKinesisStreamingDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKinesisStreamingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKinesisStreamingDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeKinesisStreamingDestination$114(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeKinesisStreamingDestinationRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeKinesisStreamingDestination$116(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeKinesisStreamingDestination$117((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLimitsResponse> describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLimitsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeLimitsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeLimitsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeLimits$121(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeLimitsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeLimits$123(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeLimits$124((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableResponse> describeTable(DescribeTableRequest describeTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeTable$128(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeTable$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeTable$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableReplicaAutoScalingResponse> describeTableReplicaAutoScaling(DescribeTableReplicaAutoScalingRequest describeTableReplicaAutoScalingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableReplicaAutoScalingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableReplicaAutoScaling");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableReplicaAutoScalingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableReplicaAutoScaling").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTableReplicaAutoScalingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeTableReplicaAutoScaling$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeTableReplicaAutoScaling$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTimeToLiveResponse> describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTimeToLiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, describeTimeToLiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTimeToLive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTimeToLiveResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = describeTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$describeTimeToLive$139(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, describeTimeToLiveRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeTimeToLive$141(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeTimeToLive$142((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableKinesisStreamingDestinationResponse> disableKinesisStreamingDestination(DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableKinesisStreamingDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKinesisStreamingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKinesisStreamingDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = disableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$disableKinesisStreamingDestination$146(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, disableKinesisStreamingDestinationRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$disableKinesisStreamingDestination$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$disableKinesisStreamingDestination$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableKinesisStreamingDestinationResponse> enableKinesisStreamingDestination(EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableKinesisStreamingDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKinesisStreamingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKinesisStreamingDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = enableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$enableKinesisStreamingDestination$153(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, enableKinesisStreamingDestinationRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$enableKinesisStreamingDestination$155(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$enableKinesisStreamingDestination$156((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExecuteStatementResponse> executeStatement(ExecuteStatementRequest executeStatementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, executeStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteStatementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)executeStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$executeStatement$159(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$executeStatement$160((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExecuteTransactionResponse> executeTransaction(ExecuteTransactionRequest executeTransactionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, executeTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteTransactionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExecuteTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)executeTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$executeTransaction$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$executeTransaction$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExportTableToPointInTimeResponse> exportTableToPointInTime(ExportTableToPointInTimeRequest exportTableToPointInTimeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportTableToPointInTimeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, exportTableToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportTableToPointInTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportTableToPointInTimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportTableToPointInTime").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExportTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)exportTableToPointInTimeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$exportTableToPointInTime$167(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$exportTableToPointInTime$168((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetItemResponse> getItem(GetItemRequest getItemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, getItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetItemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = getItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)getItemRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$getItem$172(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, getItemRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$getItem$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$getItem$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = getResourcePolicyRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)getResourcePolicyRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$getResourcePolicy$179(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, getResourcePolicyRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$getResourcePolicy$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$getResourcePolicy$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportTableResponse> importTable(ImportTableRequest importTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, importTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$importTable$185(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$importTable$186((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBackupsResponse> listBackups(ListBackupsRequest listBackupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBackupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, listBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listBackupsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listBackups$190(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listBackupsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listBackups$192(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listBackups$193((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListContributorInsightsResponse> listContributorInsights(ListContributorInsightsRequest listContributorInsightsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listContributorInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, listContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContributorInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContributorInsightsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContributorInsights").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listContributorInsightsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listContributorInsights$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listContributorInsights$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listExportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, listExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listExportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listExports$200(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listExports$201((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGlobalTablesResponse> listGlobalTables(ListGlobalTablesRequest listGlobalTablesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGlobalTablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, listGlobalTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGlobalTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGlobalTablesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listGlobalTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listGlobalTablesRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listGlobalTables$205(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listGlobalTablesRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listGlobalTables$207(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listGlobalTables$208((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listImportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listImports$211(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listImports$212((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listTablesRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listTables$216(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listTablesRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listTables$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listTables$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsOfResourceResponse> listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsOfResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsOfResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsOfResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsOfResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = listTagsOfResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listTagsOfResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$listTagsOfResource$223(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, listTagsOfResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listTagsOfResource$225(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listTagsOfResource$226((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutItemResponse> putItem(PutItemRequest putItemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, putItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutItemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = putItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)putItemRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$putItem$230(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, putItemRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$putItem$232(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$putItem$233((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = putResourcePolicyRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)putResourcePolicyRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$putResourcePolicy$237(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, putResourcePolicyRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$putResourcePolicy$239(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$putResourcePolicy$240((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)queryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, queryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = queryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)queryRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$query$244(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, queryRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$query$246(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$query$247((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreTableFromBackupResponse> restoreTableFromBackup(RestoreTableFromBackupRequest restoreTableFromBackupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreTableFromBackupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, restoreTableFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableFromBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableFromBackupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = restoreTableFromBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)restoreTableFromBackupRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$restoreTableFromBackup$251(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, restoreTableFromBackupRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$restoreTableFromBackup$253(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$restoreTableFromBackup$254((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreTableToPointInTimeResponse> restoreTableToPointInTime(RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreTableToPointInTimeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableToPointInTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableToPointInTimeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = restoreTableToPointInTimeRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$restoreTableToPointInTime$258(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, restoreTableToPointInTimeRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$restoreTableToPointInTime$260(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$restoreTableToPointInTime$261((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ScanResponse> scan(ScanRequest scanRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)scanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, scanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Scan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ScanResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = scanRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)scanRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$scan$265(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, scanRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$scan$267(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$scan$268((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$tagResource$272(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, tagResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$tagResource$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$tagResource$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TransactGetItemsResponse> transactGetItems(TransactGetItemsRequest transactGetItemsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)transactGetItemsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, transactGetItemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactGetItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactGetItemsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = transactGetItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)transactGetItemsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$transactGetItems$279(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, transactGetItemsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$transactGetItems$281(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$transactGetItems$282((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TransactWriteItemsResponse> transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)transactWriteItemsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, transactWriteItemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactWriteItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactWriteItemsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = transactWriteItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)transactWriteItemsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$transactWriteItems$286(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, transactWriteItemsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$transactWriteItems$288(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$transactWriteItems$289((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$untagResource$293(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, untagResourceRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$untagResource$295(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$untagResource$296((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContinuousBackupsResponse> updateContinuousBackups(UpdateContinuousBackupsRequest updateContinuousBackupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContinuousBackupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateContinuousBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContinuousBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContinuousBackupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateContinuousBackups$300(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateContinuousBackupsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateContinuousBackups$302(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateContinuousBackups$303((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContributorInsightsResponse> updateContributorInsights(UpdateContributorInsightsRequest updateContributorInsightsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContributorInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContributorInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContributorInsightsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContributorInsights").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateContributorInsightsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateContributorInsights$306(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateContributorInsights$307((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGlobalTableResponse> updateGlobalTable(UpdateGlobalTableRequest updateGlobalTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGlobalTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateGlobalTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateGlobalTable$311(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateGlobalTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTable$313(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTable$314((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGlobalTableSettingsResponse> updateGlobalTableSettings(UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGlobalTableSettingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTableSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateGlobalTableSettings$318(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateGlobalTableSettingsRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTableSettings$320(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTableSettings$321((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateItemResponse> updateItem(UpdateItemRequest updateItemRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateItemResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateItemRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateItem$325(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateItemRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateItem$327(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateItem$328((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateKinesisStreamingDestinationResponse> updateKinesisStreamingDestination(UpdateKinesisStreamingDestinationRequest updateKinesisStreamingDestinationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateKinesisStreamingDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKinesisStreamingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKinesisStreamingDestinationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateKinesisStreamingDestination$332(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateKinesisStreamingDestinationRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateKinesisStreamingDestination$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateKinesisStreamingDestination$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateTableRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateTable$339(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateTableRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateTable$341(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateTable$342((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableReplicaAutoScalingResponse> updateTableReplicaAutoScaling(UpdateTableReplicaAutoScalingRequest updateTableReplicaAutoScalingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableReplicaAutoScalingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableReplicaAutoScaling");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableReplicaAutoScalingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableReplicaAutoScaling").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTableReplicaAutoScalingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateTableReplicaAutoScaling$345(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateTableReplicaAutoScaling$346((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTimeToLiveResponse> updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTimeToLiveRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(clientConfiguration, updateTimeToLiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTimeToLive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTimeToLiveResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RequestLimitExceeded": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                    }
                    case "GlobalTableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                    }
                    case "ImportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                    }
                    case "ConditionalCheckFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                    }
                    case "PolicyNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "GlobalTableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                    }
                    case "ItemCollectionSizeLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                    }
                    case "ReplicaNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                    }
                    case "BackupInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ContinuousBackupsUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                    }
                    case "IdempotentParameterMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                    }
                    case "ExportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                    }
                    case "TransactionInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                    }
                    case "TableInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                    }
                    case "ProvisionedThroughputExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                    }
                    case "PointInTimeRecoveryUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "TableAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                    }
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ExportConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                    }
                    case "TransactionConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                    }
                    case "InvalidRestoreTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                    }
                    case "ReplicaAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                    }
                    case "ReplicatedWriteConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                    }
                    case "BackupNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                    }
                    case "IndexNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                    }
                    case "TableNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                    }
                    case "DuplicateItemException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                    }
                    case "ImportNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                    }
                    case "TransactionCanceledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                    }
                    case "InvalidExportTimeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                    }
                    case "InternalServerError": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            boolean endpointDiscoveryEnabled = (Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = ((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
            CompletionStage<Object> endpointFuture = CompletableFuture.completedFuture(null);
            if (endpointDiscoveryEnabled) {
                CompletableFuture identityFuture = updateTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
                endpointFuture = identityFuture.thenCompose(credentials -> {
                    EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
                    return this.endpointDiscoveryCache.getAsync(credentials.accessKeyId(), endpointDiscoveryRequest);
                });
            }
            CompletionStage executeFuture = endpointFuture.thenCompose(arg_0 -> this.lambda$updateTimeToLive$350(responseHandler, errorResponseHandler, clientConfiguration, (MetricCollector)apiCallMetricCollector, updateTimeToLiveRequest, arg_0));
            CompletionStage whenCompleted = ((CompletableFuture)executeFuture).whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateTimeToLive$352(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateTimeToLive$353((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DynamoDbAsyncWaiter waiter() {
        return DynamoDbAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final DynamoDbServiceClientConfiguration serviceClientConfiguration() {
        return new DynamoDbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "dynamodb";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DynamoDbException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        DynamoDbServiceClientConfigurationBuilder serviceConfigBuilder = new DynamoDbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTimeToLive$353(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTimeToLive$352(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTimeToLiveResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateTimeToLive$350(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateTimeToLiveRequest updateTimeToLiveRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTimeToLive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTimeToLiveRequest));
    }

    private static /* synthetic */ void lambda$updateTableReplicaAutoScaling$346(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTableReplicaAutoScaling$345(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableReplicaAutoScalingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTable$342(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$341(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateTable$339(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateTableRequest updateTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTableRequest));
    }

    private static /* synthetic */ void lambda$updateKinesisStreamingDestination$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKinesisStreamingDestination$334(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateKinesisStreamingDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateKinesisStreamingDestination$332(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateKinesisStreamingDestinationRequest updateKinesisStreamingDestinationRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateKinesisStreamingDestinationRequest));
    }

    private static /* synthetic */ void lambda$updateItem$328(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateItem$327(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateItem$325(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateItemRequest updateItemRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateItemRequest));
    }

    private static /* synthetic */ void lambda$updateGlobalTableSettings$321(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTableSettings$320(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGlobalTableSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateGlobalTableSettings$318(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTableSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateGlobalTableSettingsRequest));
    }

    private static /* synthetic */ void lambda$updateGlobalTable$314(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTable$313(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGlobalTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateGlobalTable$311(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateGlobalTableRequest updateGlobalTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateGlobalTableRequest));
    }

    private static /* synthetic */ void lambda$updateContributorInsights$307(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContributorInsights$306(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContributorInsightsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateContinuousBackups$303(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContinuousBackups$302(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContinuousBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$updateContinuousBackups$300(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UpdateContinuousBackupsRequest updateContinuousBackupsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContinuousBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateContinuousBackupsRequest));
    }

    private static /* synthetic */ void lambda$untagResource$296(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$295(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$untagResource$293(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, UntagResourceRequest untagResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest));
    }

    private static /* synthetic */ void lambda$transactWriteItems$289(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactWriteItems$288(List metricPublishers, MetricCollector apiCallMetricCollector, TransactWriteItemsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$transactWriteItems$286(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, TransactWriteItemsRequest transactWriteItemsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactWriteItems").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TransactWriteItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)transactWriteItemsRequest));
    }

    private static /* synthetic */ void lambda$transactGetItems$282(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactGetItems$281(List metricPublishers, MetricCollector apiCallMetricCollector, TransactGetItemsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$transactGetItems$279(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, TransactGetItemsRequest transactGetItemsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactGetItems").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TransactGetItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)transactGetItemsRequest));
    }

    private static /* synthetic */ void lambda$tagResource$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$274(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$tagResource$272(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, TagResourceRequest tagResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest));
    }

    private static /* synthetic */ void lambda$scan$268(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$scan$267(List metricPublishers, MetricCollector apiCallMetricCollector, ScanResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$scan$265(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ScanRequest scanRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("Scan").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)scanRequest));
    }

    private static /* synthetic */ void lambda$restoreTableToPointInTime$261(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableToPointInTime$260(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreTableToPointInTimeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$restoreTableToPointInTime$258(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableToPointInTime").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)restoreTableToPointInTimeRequest));
    }

    private static /* synthetic */ void lambda$restoreTableFromBackup$254(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableFromBackup$253(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreTableFromBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$restoreTableFromBackup$251(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, RestoreTableFromBackupRequest restoreTableFromBackupRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreTableFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)restoreTableFromBackupRequest));
    }

    private static /* synthetic */ void lambda$query$247(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$246(List metricPublishers, MetricCollector apiCallMetricCollector, QueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$query$244(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, QueryRequest queryRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)queryRequest));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$240(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$239(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$putResourcePolicy$237(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, PutResourcePolicyRequest putResourcePolicyRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)putResourcePolicyRequest));
    }

    private static /* synthetic */ void lambda$putItem$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putItem$232(List metricPublishers, MetricCollector apiCallMetricCollector, PutItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$putItem$230(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, PutItemRequest putItemRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)putItemRequest));
    }

    private static /* synthetic */ void lambda$listTagsOfResource$226(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsOfResource$225(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsOfResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listTagsOfResource$223(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListTagsOfResourceRequest listTagsOfResourceRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsOfResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsOfResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsOfResourceRequest));
    }

    private static /* synthetic */ void lambda$listTables$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$218(List metricPublishers, MetricCollector apiCallMetricCollector, ListTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listTables$216(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListTablesRequest listTablesRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTablesRequest));
    }

    private static /* synthetic */ void lambda$listImports$212(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImports$211(List metricPublishers, MetricCollector apiCallMetricCollector, ListImportsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGlobalTables$208(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGlobalTables$207(List metricPublishers, MetricCollector apiCallMetricCollector, ListGlobalTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listGlobalTables$205(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListGlobalTablesRequest listGlobalTablesRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGlobalTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListGlobalTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listGlobalTablesRequest));
    }

    private static /* synthetic */ void lambda$listExports$201(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExports$200(List metricPublishers, MetricCollector apiCallMetricCollector, ListExportsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listContributorInsights$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContributorInsights$196(List metricPublishers, MetricCollector apiCallMetricCollector, ListContributorInsightsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBackups$193(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBackups$192(List metricPublishers, MetricCollector apiCallMetricCollector, ListBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$listBackups$190(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, ListBackupsRequest listBackupsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listBackupsRequest));
    }

    private static /* synthetic */ void lambda$importTable$186(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importTable$185(List metricPublishers, MetricCollector apiCallMetricCollector, ImportTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourcePolicy$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$181(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$getResourcePolicy$179(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, GetResourcePolicyRequest getResourcePolicyRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)getResourcePolicyRequest));
    }

    private static /* synthetic */ void lambda$getItem$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getItem$174(List metricPublishers, MetricCollector apiCallMetricCollector, GetItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$getItem$172(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, GetItemRequest getItemRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)getItemRequest));
    }

    private static /* synthetic */ void lambda$exportTableToPointInTime$168(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportTableToPointInTime$167(List metricPublishers, MetricCollector apiCallMetricCollector, ExportTableToPointInTimeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$executeTransaction$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeTransaction$163(List metricPublishers, MetricCollector apiCallMetricCollector, ExecuteTransactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$executeStatement$160(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeStatement$159(List metricPublishers, MetricCollector apiCallMetricCollector, ExecuteStatementResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableKinesisStreamingDestination$156(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKinesisStreamingDestination$155(List metricPublishers, MetricCollector apiCallMetricCollector, EnableKinesisStreamingDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$enableKinesisStreamingDestination$153(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new EnableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)enableKinesisStreamingDestinationRequest));
    }

    private static /* synthetic */ void lambda$disableKinesisStreamingDestination$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKinesisStreamingDestination$148(List metricPublishers, MetricCollector apiCallMetricCollector, DisableKinesisStreamingDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$disableKinesisStreamingDestination$146(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)disableKinesisStreamingDestinationRequest));
    }

    private static /* synthetic */ void lambda$describeTimeToLive$142(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTimeToLive$141(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTimeToLiveResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeTimeToLive$139(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeTimeToLiveRequest describeTimeToLiveRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTimeToLive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTimeToLiveRequest));
    }

    private static /* synthetic */ void lambda$describeTableReplicaAutoScaling$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTableReplicaAutoScaling$134(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTableReplicaAutoScalingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTable$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$130(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeTable$128(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeTableRequest describeTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTableRequest));
    }

    private static /* synthetic */ void lambda$describeLimits$124(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLimits$123(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLimitsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeLimits$121(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeLimitsRequest describeLimitsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeLimitsRequest));
    }

    private static /* synthetic */ void lambda$describeKinesisStreamingDestination$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKinesisStreamingDestination$116(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeKinesisStreamingDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeKinesisStreamingDestination$114(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeKinesisStreamingDestinationRequest));
    }

    private static /* synthetic */ void lambda$describeImport$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImport$109(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeImportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeGlobalTableSettings$106(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTableSettings$105(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGlobalTableSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeGlobalTableSettings$103(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTableSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeGlobalTableSettingsRequest));
    }

    private static /* synthetic */ void lambda$describeGlobalTable$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTable$98(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGlobalTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeGlobalTable$96(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeGlobalTableRequest describeGlobalTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeGlobalTableRequest));
    }

    private static /* synthetic */ void lambda$describeExport$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExport$91(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeExportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEndpoints$88(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$87(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeContributorInsights$84(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContributorInsights$83(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeContributorInsightsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeContinuousBackups$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContinuousBackups$79(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeContinuousBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeContinuousBackups$77(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeContinuousBackupsRequest describeContinuousBackupsRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContinuousBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeContinuousBackupsRequest));
    }

    private static /* synthetic */ void lambda$describeBackup$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackup$72(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$describeBackup$70(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DescribeBackupRequest describeBackupRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeBackupRequest));
    }

    private static /* synthetic */ void lambda$deleteTable$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$65(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$deleteTable$63(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DeleteTableRequest deleteTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteTableRequest));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$deleteResourcePolicy$56(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DeleteResourcePolicyRequest deleteResourcePolicyRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteResourcePolicyRequest));
    }

    private static /* synthetic */ void lambda$deleteItem$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteItem$51(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$deleteItem$49(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DeleteItemRequest deleteItemRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteItemRequest));
    }

    private static /* synthetic */ void lambda$deleteBackup$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$44(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$deleteBackup$42(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, DeleteBackupRequest deleteBackupRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteBackupRequest));
    }

    private static /* synthetic */ void lambda$createTable$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$37(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$createTable$35(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CreateTableRequest createTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createTableRequest));
    }

    private static /* synthetic */ void lambda$createGlobalTable$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGlobalTable$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateGlobalTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$createGlobalTable$28(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CreateGlobalTableRequest createGlobalTableRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGlobalTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createGlobalTableRequest));
    }

    private static /* synthetic */ void lambda$createBackup$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackup$23(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$createBackup$21(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, CreateBackupRequest createBackupRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createBackupRequest));
    }

    private static /* synthetic */ void lambda$batchWriteItem$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchWriteItem$16(List metricPublishers, MetricCollector apiCallMetricCollector, BatchWriteItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$batchWriteItem$14(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, BatchWriteItemRequest batchWriteItemRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchWriteItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchWriteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)batchWriteItemRequest));
    }

    private static /* synthetic */ void lambda$batchGetItem$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetItem$9(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private /* synthetic */ CompletionStage lambda$batchGetItem$7(HttpResponseHandler responseHandler, HttpResponseHandler errorResponseHandler, SdkClientConfiguration clientConfiguration, MetricCollector apiCallMetricCollector, BatchGetItemRequest batchGetItemRequest, URI cachedEndpoint) {
        return this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)batchGetItemRequest));
    }

    private static /* synthetic */ void lambda$batchExecuteStatement$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchExecuteStatement$2(List metricPublishers, MetricCollector apiCallMetricCollector, BatchExecuteStatementResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

