/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request was denied due to request throttling. For detailed information about why the request was throttled and
 * the ARN of the impacted resource, find the <a
 * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">ThrottlingReason</a>
 * field in the returned exception. The Amazon Web Services SDKs for DynamoDB automatically retry requests that receive
 * this exception. Your request is eventually successful, unless your retry queue is too large to finish. Reduce the
 * frequency of requests and use exponential backoff. For more information, go to <a href=
 * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
 * >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedThroughputExceededException extends DynamoDbException implements
        ToCopyableBuilder<ProvisionedThroughputExceededException.Builder, ProvisionedThroughputExceededException> {
    private static final SdkField<List<ThrottlingReason>> THROTTLING_REASONS_FIELD = SdkField
            .<List<ThrottlingReason>> builder(MarshallingType.LIST)
            .memberName("ThrottlingReasons")
            .getter(getter(ProvisionedThroughputExceededException::throttlingReasons))
            .setter(setter(Builder::throttlingReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrottlingReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThrottlingReason> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThrottlingReason::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THROTTLING_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ThrottlingReason> throttlingReasons;

    private ProvisionedThroughputExceededException(BuilderImpl builder) {
        super(builder);
        this.throttlingReasons = builder.throttlingReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThrottlingReasons property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasThrottlingReasons() {
        return throttlingReasons != null && !(throttlingReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
     * ThrottlingReason</a> that provide detailed diagnostic information about why the request was throttled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThrottlingReasons} method.
     * </p>
     * 
     * @return A list of <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
     *         >ThrottlingReason</a> that provide detailed diagnostic information about why the request was throttled.
     */
    public List<ThrottlingReason> throttlingReasons() {
        return throttlingReasons;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ThrottlingReasons", THROTTLING_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedThroughputExceededException, T> g) {
        return obj -> g.apply((ProvisionedThroughputExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedThroughputExceededException>,
            DynamoDbException.Builder {
        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
         * ThrottlingReason</a> that provide detailed diagnostic information about why the request was throttled.
         * </p>
         * 
         * @param throttlingReasons
         *        A list of <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
         *        >ThrottlingReason</a> that provide detailed diagnostic information about why the request was
         *        throttled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingReasons(Collection<ThrottlingReason> throttlingReasons);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
         * ThrottlingReason</a> that provide detailed diagnostic information about why the request was throttled.
         * </p>
         * 
         * @param throttlingReasons
         *        A list of <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html"
         *        >ThrottlingReason</a> that provide detailed diagnostic information about why the request was
         *        throttled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingReasons(ThrottlingReason... throttlingReasons);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ThrottlingReason.html">
         * ThrottlingReason</a> that provide detailed diagnostic information about why the request was throttled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.ThrottlingReason.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dynamodb.model.ThrottlingReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.ThrottlingReason.Builder#build()} is called immediately
         * and its result is passed to {@link #throttlingReasons(List<ThrottlingReason>)}.
         * 
         * @param throttlingReasons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.ThrottlingReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #throttlingReasons(java.util.Collection<ThrottlingReason>)
         */
        Builder throttlingReasons(Consumer<ThrottlingReason.Builder>... throttlingReasons);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends DynamoDbException.BuilderImpl implements Builder {
        private List<ThrottlingReason> throttlingReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputExceededException model) {
            super(model);
            throttlingReasons(model.throttlingReasons);
        }

        public final List<ThrottlingReason.Builder> getThrottlingReasons() {
            List<ThrottlingReason.Builder> result = ThrottlingReasonListCopier.copyToBuilder(this.throttlingReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThrottlingReasons(Collection<ThrottlingReason.BuilderImpl> throttlingReasons) {
            this.throttlingReasons = ThrottlingReasonListCopier.copyFromBuilder(throttlingReasons);
        }

        @Override
        public final Builder throttlingReasons(Collection<ThrottlingReason> throttlingReasons) {
            this.throttlingReasons = ThrottlingReasonListCopier.copy(throttlingReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throttlingReasons(ThrottlingReason... throttlingReasons) {
            throttlingReasons(Arrays.asList(throttlingReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder throttlingReasons(Consumer<ThrottlingReason.Builder>... throttlingReasons) {
            throttlingReasons(Stream.of(throttlingReasons).map(c -> ThrottlingReason.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ProvisionedThroughputExceededException build() {
            return new ProvisionedThroughputExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
