/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Overrides the on-demand throughput settings for this replica table. If you don't specify a value for this parameter,
 * it uses the source table's on-demand throughput settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDemandThroughputOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<OnDemandThroughputOverride.Builder, OnDemandThroughputOverride> {
    private static final SdkField<Long> MAX_READ_REQUEST_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxReadRequestUnits").getter(getter(OnDemandThroughputOverride::maxReadRequestUnits))
            .setter(setter(Builder::maxReadRequestUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxReadRequestUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_READ_REQUEST_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long maxReadRequestUnits;

    private OnDemandThroughputOverride(BuilderImpl builder) {
        this.maxReadRequestUnits = builder.maxReadRequestUnits;
    }

    /**
     * <p>
     * Maximum number of read request units for the specified replica table.
     * </p>
     * 
     * @return Maximum number of read request units for the specified replica table.
     */
    public final Long maxReadRequestUnits() {
        return maxReadRequestUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxReadRequestUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandThroughputOverride)) {
            return false;
        }
        OnDemandThroughputOverride other = (OnDemandThroughputOverride) obj;
        return Objects.equals(maxReadRequestUnits(), other.maxReadRequestUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OnDemandThroughputOverride").add("MaxReadRequestUnits", maxReadRequestUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxReadRequestUnits":
            return Optional.ofNullable(clazz.cast(maxReadRequestUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxReadRequestUnits", MAX_READ_REQUEST_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OnDemandThroughputOverride, T> g) {
        return obj -> g.apply((OnDemandThroughputOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDemandThroughputOverride> {
        /**
         * <p>
         * Maximum number of read request units for the specified replica table.
         * </p>
         * 
         * @param maxReadRequestUnits
         *        Maximum number of read request units for the specified replica table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxReadRequestUnits(Long maxReadRequestUnits);
    }

    static final class BuilderImpl implements Builder {
        private Long maxReadRequestUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandThroughputOverride model) {
            maxReadRequestUnits(model.maxReadRequestUnits);
        }

        public final Long getMaxReadRequestUnits() {
            return maxReadRequestUnits;
        }

        public final void setMaxReadRequestUnits(Long maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
        }

        @Override
        public final Builder maxReadRequestUnits(Long maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
            return this;
        }

        @Override
        public OnDemandThroughputOverride build() {
            return new OnDemandThroughputOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
