/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.dynamodb.DynamoDbServiceClientConfiguration;
import software.amazon.awssdk.services.dynamodb.internal.DynamoDbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.dynamodb.model.BackupInUseException;
import software.amazon.awssdk.services.dynamodb.model.BackupNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DuplicateItemException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ExportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.ImportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ImportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ImportTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ImportTableResponse;
import software.amazon.awssdk.services.dynamodb.model.IndexNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.InvalidExportTimeException;
import software.amazon.awssdk.services.dynamodb.model.InvalidRestoreTimeException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListImportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListImportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.PolicyNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.dynamodb.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.ReplicaNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ReplicatedWriteConflictException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.TableInUseException;
import software.amazon.awssdk.services.dynamodb.model.TableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TransactionInProgressException;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.transform.BatchExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchGetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchWriteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeExportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeImportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeLimitsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DisableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.EnableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteTransactionRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExportTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ImportTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListGlobalTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTagsOfResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableFromBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ScanRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactGetItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactWriteItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDynamoDbClient
implements DynamoDbClient {
    private static final Logger log = Logger.loggerFor(DefaultDynamoDbClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultDynamoDbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"DynamoDB#2.32.1").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)DynamoDbEndpointDiscoveryCacheLoader.create(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchExecuteStatementResponse batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest) throws RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchExecuteStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchExecuteStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, batchExecuteStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchExecuteStatement");
            BatchExecuteStatementResponse batchExecuteStatementResponse = (BatchExecuteStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchExecuteStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchExecuteStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchExecuteStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$batchExecuteStatement$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetItemResponse batchGetItem(BatchGetItemRequest batchGetItemRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = batchGetItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)batchGetItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetItemRequest, this.clientConfiguration), batchGetItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetItem");
            BatchGetItemResponse batchGetItemResponse = (BatchGetItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$batchGetItem$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchWriteItemResponse batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchWriteItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = batchWriteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)batchWriteItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchWriteItemRequest, this.clientConfiguration), batchWriteItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchWriteItem");
            BatchWriteItemResponse batchWriteItemResponse = (BatchWriteItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchWriteItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchWriteItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchWriteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchWriteItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$batchWriteItem$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws TableNotFoundException, TableInUseException, ContinuousBackupsUnavailableException, BackupInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = createBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBackupRequest, this.clientConfiguration), createBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackup");
            CreateBackupResponse createBackupResponse = (CreateBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$createBackup$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGlobalTableResponse createGlobalTable(CreateGlobalTableRequest createGlobalTableRequest) throws LimitExceededException, InternalServerErrorException, GlobalTableAlreadyExistsException, TableNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGlobalTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = createGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createGlobalTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGlobalTableRequest, this.clientConfiguration), createGlobalTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGlobalTable");
            CreateGlobalTableResponse createGlobalTableResponse = (CreateGlobalTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGlobalTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createGlobalTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGlobalTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$createGlobalTable$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws ResourceInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = createTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTableRequest, this.clientConfiguration), createTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            CreateTableResponse createTableResponse = (CreateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$createTable$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws BackupNotFoundException, BackupInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = deleteBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBackupRequest, this.clientConfiguration), deleteBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            DeleteBackupResponse deleteBackupResponse = (DeleteBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$deleteBackup$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteItemResponse deleteItem(DeleteItemRequest deleteItemRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = deleteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteItemRequest, this.clientConfiguration), deleteItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteItem");
            DeleteItemResponse deleteItemResponse = (DeleteItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$deleteItem$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws ResourceNotFoundException, InternalServerErrorException, PolicyNotFoundException, ResourceInUseException, LimitExceededException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = deleteResourcePolicyRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteResourcePolicyRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration), deleteResourcePolicyRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$deleteResourcePolicy$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = deleteTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTableRequest, this.clientConfiguration), deleteTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            DeleteTableResponse deleteTableResponse = (DeleteTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$deleteTable$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupResponse describeBackup(DescribeBackupRequest describeBackupRequest) throws BackupNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBackupRequest, this.clientConfiguration), describeBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackup");
            DescribeBackupResponse describeBackupResponse = (DescribeBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeBackup$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContinuousBackupsResponse describeContinuousBackups(DescribeContinuousBackupsRequest describeContinuousBackupsRequest) throws TableNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContinuousBackupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContinuousBackupsRequest, this.clientConfiguration), describeContinuousBackupsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContinuousBackups");
            DescribeContinuousBackupsResponse describeContinuousBackupsResponse = (DescribeContinuousBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContinuousBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeContinuousBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeContinuousBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeContinuousBackups$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContributorInsightsResponse describeContributorInsights(DescribeContributorInsightsRequest describeContributorInsightsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContributorInsightsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContributorInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, describeContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContributorInsights");
            DescribeContributorInsightsResponse describeContributorInsightsResponse = (DescribeContributorInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContributorInsights").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeContributorInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeContributorInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeContributorInsights$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            DescribeEndpointsResponse describeEndpointsResponse = (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeEndpoints$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExportResponse describeExport(DescribeExportRequest describeExportRequest) throws ExportNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, describeExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExport");
            DescribeExportResponse describeExportResponse = (DescribeExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeExport$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGlobalTableResponse describeGlobalTable(DescribeGlobalTableRequest describeGlobalTableRequest) throws InternalServerErrorException, GlobalTableNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGlobalTableRequest, this.clientConfiguration), describeGlobalTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTable");
            DescribeGlobalTableResponse describeGlobalTableResponse = (DescribeGlobalTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeGlobalTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGlobalTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeGlobalTable$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGlobalTableSettingsResponse describeGlobalTableSettings(DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest) throws GlobalTableNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGlobalTableSettingsRequest, this.clientConfiguration), describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTableSettings");
            DescribeGlobalTableSettingsResponse describeGlobalTableSettingsResponse = (DescribeGlobalTableSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTableSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeGlobalTableSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGlobalTableSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeGlobalTableSettings$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeImportResponse describeImport(DescribeImportRequest describeImportRequest) throws ImportNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, describeImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImport");
            DescribeImportResponse describeImportResponse = (DescribeImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeImport$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeKinesisStreamingDestinationResponse describeKinesisStreamingDestination(DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKinesisStreamingDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeKinesisStreamingDestinationRequest, this.clientConfiguration), describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKinesisStreamingDestination");
            DescribeKinesisStreamingDestinationResponse describeKinesisStreamingDestinationResponse = (DescribeKinesisStreamingDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeKinesisStreamingDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeKinesisStreamingDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeKinesisStreamingDestination$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeLimitsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeLimitsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLimitsRequest, this.clientConfiguration), describeLimitsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLimits");
            DescribeLimitsResponse describeLimitsResponse = (DescribeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeLimits$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableRequest, this.clientConfiguration), describeTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            DescribeTableResponse describeTableResponse = (DescribeTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeTable$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableReplicaAutoScalingResponse describeTableReplicaAutoScaling(DescribeTableReplicaAutoScalingRequest describeTableReplicaAutoScalingRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableReplicaAutoScalingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableReplicaAutoScalingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, describeTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableReplicaAutoScaling");
            DescribeTableReplicaAutoScalingResponse describeTableReplicaAutoScalingResponse = (DescribeTableReplicaAutoScalingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableReplicaAutoScaling").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTableReplicaAutoScalingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableReplicaAutoScalingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeTableReplicaAutoScaling$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTimeToLiveResponse describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTimeToLiveResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTimeToLiveRequest, this.clientConfiguration), describeTimeToLiveRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTimeToLive");
            DescribeTimeToLiveResponse describeTimeToLiveResponse = (DescribeTimeToLiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTimeToLive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTimeToLiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTimeToLiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeTimeToLive$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableKinesisStreamingDestinationResponse disableKinesisStreamingDestination(DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest) throws InternalServerErrorException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKinesisStreamingDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = disableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableKinesisStreamingDestinationRequest, this.clientConfiguration), disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKinesisStreamingDestination");
            DisableKinesisStreamingDestinationResponse disableKinesisStreamingDestinationResponse = (DisableKinesisStreamingDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableKinesisStreamingDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableKinesisStreamingDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$disableKinesisStreamingDestination$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableKinesisStreamingDestinationResponse enableKinesisStreamingDestination(EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest) throws InternalServerErrorException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKinesisStreamingDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = enableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableKinesisStreamingDestinationRequest, this.clientConfiguration), enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKinesisStreamingDestination");
            EnableKinesisStreamingDestinationResponse enableKinesisStreamingDestinationResponse = (EnableKinesisStreamingDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableKinesisStreamingDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableKinesisStreamingDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$enableKinesisStreamingDestination$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteStatementResponse executeStatement(ExecuteStatementRequest executeStatementRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, DuplicateItemException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, executeStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteStatement");
            ExecuteStatementResponse executeStatementResponse = (ExecuteStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)executeStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$executeStatement$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteTransactionResponse executeTransaction(ExecuteTransactionRequest executeTransactionRequest) throws ResourceNotFoundException, TransactionCanceledException, TransactionInProgressException, IdempotentParameterMismatchException, ProvisionedThroughputExceededException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteTransactionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeTransactionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, executeTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteTransaction");
            ExecuteTransactionResponse executeTransactionResponse = (ExecuteTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteTransaction").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)executeTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$executeTransaction$72((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportTableToPointInTimeResponse exportTableToPointInTime(ExportTableToPointInTimeRequest exportTableToPointInTimeRequest) throws TableNotFoundException, PointInTimeRecoveryUnavailableException, LimitExceededException, InvalidExportTimeException, ExportConflictException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportTableToPointInTimeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportTableToPointInTimeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, exportTableToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportTableToPointInTime");
            ExportTableToPointInTimeResponse exportTableToPointInTimeResponse = (ExportTableToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportTableToPointInTime").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)exportTableToPointInTimeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportTableToPointInTimeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$exportTableToPointInTime$74((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetItemResponse getItem(GetItemRequest getItemRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = getItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)getItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getItemRequest, this.clientConfiguration), getItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetItem");
            GetItemResponse getItemResponse = (GetItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$getItem$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws ResourceNotFoundException, InternalServerErrorException, PolicyNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = getResourcePolicyRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)getResourcePolicyRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration), getResourcePolicyRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$getResourcePolicy$80((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportTableResponse importTable(ImportTableRequest importTableRequest) throws ResourceInUseException, LimitExceededException, ImportConflictException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, importTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportTable");
            ImportTableResponse importTableResponse = (ImportTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$importTable$82((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBackupsResponse listBackups(ListBackupsRequest listBackupsRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = listBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listBackupsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBackupsRequest, this.clientConfiguration), listBackupsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBackups");
            ListBackupsResponse listBackupsResponse = (ListBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listBackups$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContributorInsightsResponse listContributorInsights(ListContributorInsightsRequest listContributorInsightsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContributorInsightsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listContributorInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, listContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContributorInsights");
            ListContributorInsightsResponse listContributorInsightsResponse = (ListContributorInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContributorInsights").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listContributorInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listContributorInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listContributorInsights$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listExportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, listExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExports");
            ListExportsResponse listExportsResponse = (ListExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listExportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listExports$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGlobalTablesResponse listGlobalTables(ListGlobalTablesRequest listGlobalTablesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGlobalTablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = listGlobalTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listGlobalTablesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGlobalTablesRequest, this.clientConfiguration), listGlobalTablesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGlobalTables");
            ListGlobalTablesResponse listGlobalTablesResponse = (ListGlobalTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGlobalTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listGlobalTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGlobalTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGlobalTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listGlobalTables$92((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            ListImportsResponse listImportsResponse = (ListImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listImports$94((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = listTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listTablesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTablesRequest, this.clientConfiguration), listTablesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            ListTablesResponse listTablesResponse = (ListTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listTables$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsOfResourceResponse listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsOfResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = listTagsOfResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listTagsOfResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsOfResourceRequest, this.clientConfiguration), listTagsOfResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsOfResource");
            ListTagsOfResourceResponse listTagsOfResourceResponse = (ListTagsOfResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsOfResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsOfResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsOfResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsOfResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listTagsOfResource$100((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutItemResponse putItem(PutItemRequest putItemRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = putItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)putItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putItemRequest, this.clientConfiguration), putItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutItem");
            PutItemResponse putItemResponse = (PutItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$putItem$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws ResourceNotFoundException, InternalServerErrorException, LimitExceededException, PolicyNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = putResourcePolicyRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)putResourcePolicyRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration), putResourcePolicyRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$putResourcePolicy$106((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse query(QueryRequest queryRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = queryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)queryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)queryRequest, this.clientConfiguration), queryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            QueryResponse queryResponse = (QueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)queryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$query$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreTableFromBackupResponse restoreTableFromBackup(RestoreTableFromBackupRequest restoreTableFromBackupRequest) throws TableAlreadyExistsException, TableInUseException, BackupNotFoundException, BackupInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableFromBackupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = restoreTableFromBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)restoreTableFromBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreTableFromBackupRequest, this.clientConfiguration), restoreTableFromBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableFromBackup");
            RestoreTableFromBackupResponse restoreTableFromBackupResponse = (RestoreTableFromBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromBackup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreTableFromBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreTableFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreTableFromBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$restoreTableFromBackup$112((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreTableToPointInTimeResponse restoreTableToPointInTime(RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest) throws TableAlreadyExistsException, TableNotFoundException, TableInUseException, LimitExceededException, InvalidRestoreTimeException, PointInTimeRecoveryUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableToPointInTimeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = restoreTableToPointInTimeRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreTableToPointInTimeRequest, this.clientConfiguration), restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableToPointInTime");
            RestoreTableToPointInTimeResponse restoreTableToPointInTimeResponse = (RestoreTableToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableToPointInTime").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restoreTableToPointInTimeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreTableToPointInTimeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$restoreTableToPointInTime$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResponse scan(ScanRequest scanRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ScanResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = scanRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)scanRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)scanRequest, this.clientConfiguration), scanRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Scan");
            ScanResponse scanResponse = (ScanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Scan").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)scanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return scanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$scan$118((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException, ResourceNotFoundException, InternalServerErrorException, ResourceInUseException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration), tagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$tagResource$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactGetItemsResponse transactGetItems(TransactGetItemsRequest transactGetItemsRequest) throws ResourceNotFoundException, TransactionCanceledException, ProvisionedThroughputExceededException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactGetItemsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = transactGetItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)transactGetItemsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)transactGetItemsRequest, this.clientConfiguration), transactGetItemsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactGetItems");
            TransactGetItemsResponse transactGetItemsResponse = (TransactGetItemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactGetItems").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)transactGetItemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TransactGetItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return transactGetItemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$transactGetItems$124((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactWriteItemsResponse transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest) throws ResourceNotFoundException, TransactionCanceledException, TransactionInProgressException, IdempotentParameterMismatchException, ProvisionedThroughputExceededException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactWriteItemsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = transactWriteItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)transactWriteItemsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)transactWriteItemsRequest, this.clientConfiguration), transactWriteItemsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactWriteItems");
            TransactWriteItemsResponse transactWriteItemsResponse = (TransactWriteItemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactWriteItems").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)transactWriteItemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TransactWriteItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return transactWriteItemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$transactWriteItems$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws LimitExceededException, ResourceNotFoundException, InternalServerErrorException, ResourceInUseException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration), untagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$untagResource$130((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContinuousBackupsResponse updateContinuousBackups(UpdateContinuousBackupsRequest updateContinuousBackupsRequest) throws TableNotFoundException, ContinuousBackupsUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContinuousBackupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContinuousBackupsRequest, this.clientConfiguration), updateContinuousBackupsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContinuousBackups");
            UpdateContinuousBackupsResponse updateContinuousBackupsResponse = (UpdateContinuousBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContinuousBackups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateContinuousBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContinuousBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateContinuousBackups$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContributorInsightsResponse updateContributorInsights(UpdateContributorInsightsRequest updateContributorInsightsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContributorInsightsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateContributorInsightsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, updateContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContributorInsights");
            UpdateContributorInsightsResponse updateContributorInsightsResponse = (UpdateContributorInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContributorInsights").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateContributorInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContributorInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateContributorInsights$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGlobalTableResponse updateGlobalTable(UpdateGlobalTableRequest updateGlobalTableRequest) throws InternalServerErrorException, GlobalTableNotFoundException, ReplicaAlreadyExistsException, ReplicaNotFoundException, TableNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGlobalTableRequest, this.clientConfiguration), updateGlobalTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTable");
            UpdateGlobalTableResponse updateGlobalTableResponse = (UpdateGlobalTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGlobalTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGlobalTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateGlobalTable$138((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGlobalTableSettingsResponse updateGlobalTableSettings(UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) throws GlobalTableNotFoundException, ReplicaNotFoundException, IndexNotFoundException, LimitExceededException, ResourceInUseException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGlobalTableSettingsRequest, this.clientConfiguration), updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTableSettings");
            UpdateGlobalTableSettingsResponse updateGlobalTableSettingsResponse = (UpdateGlobalTableSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTableSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateGlobalTableSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGlobalTableSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateGlobalTableSettings$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateItemResponse updateItem(UpdateItemRequest updateItemRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, ReplicatedWriteConflictException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateItemRequest, this.clientConfiguration), updateItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateItem");
            UpdateItemResponse updateItemResponse = (UpdateItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateItem").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateItem$144((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateKinesisStreamingDestinationResponse updateKinesisStreamingDestination(UpdateKinesisStreamingDestinationRequest updateKinesisStreamingDestinationRequest) throws InternalServerErrorException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateKinesisStreamingDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateKinesisStreamingDestinationRequest, this.clientConfiguration), updateKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKinesisStreamingDestination");
            UpdateKinesisStreamingDestinationResponse updateKinesisStreamingDestinationResponse = (UpdateKinesisStreamingDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKinesisStreamingDestination").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateKinesisStreamingDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateKinesisStreamingDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateKinesisStreamingDestination$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableRequest, this.clientConfiguration), updateTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            UpdateTableResponse updateTableResponse = (UpdateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateTable$150((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableReplicaAutoScalingResponse updateTableReplicaAutoScaling(UpdateTableReplicaAutoScalingRequest updateTableReplicaAutoScalingRequest) throws ResourceNotFoundException, ResourceInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableReplicaAutoScalingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTableReplicaAutoScalingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration, updateTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableReplicaAutoScaling");
            UpdateTableReplicaAutoScalingResponse updateTableReplicaAutoScalingResponse = (UpdateTableReplicaAutoScalingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableReplicaAutoScaling").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTableReplicaAutoScalingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableReplicaAutoScalingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateTableReplicaAutoScaling$152((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTimeToLiveResponse updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTimeToLiveResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "RequestLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestLimitExceededException::builder).build());
                }
                case "GlobalTableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).build());
                }
                case "ImportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportConflictException::builder).build());
                }
                case "ConditionalCheckFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConditionalCheckFailedException::builder).build());
                }
                case "PolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PolicyNotFoundException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "GlobalTableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GlobalTableNotFoundException::builder).build());
                }
                case "ItemCollectionSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).build());
                }
                case "ReplicaNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaNotFoundException::builder).build());
                }
                case "BackupInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupInUseException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ContinuousBackupsUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).build());
                }
                case "IdempotentParameterMismatchException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "ExportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportNotFoundException::builder).build());
                }
                case "TransactionInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionInProgressException::builder).build());
                }
                case "TableInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableInUseException::builder).build());
                }
                case "ProvisionedThroughputExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).build());
                }
                case "PointInTimeRecoveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "TableAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableAlreadyExistsException::builder).build());
                }
                case "ExportConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExportConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExportConflictException::builder).build());
                }
                case "TransactionConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionConflictException::builder).build());
                }
                case "InvalidRestoreTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRestoreTimeException::builder).build());
                }
                case "ReplicaAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).build());
                }
                case "ReplicatedWriteConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReplicatedWriteConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ReplicatedWriteConflictException::builder).build());
                }
                case "BackupNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BackupNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackupNotFoundException::builder).build());
                }
                case "IndexNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IndexNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IndexNotFoundException::builder).build());
                }
                case "TableNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TableNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TableNotFoundException::builder).build());
                }
                case "DuplicateItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateItemException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "TransactionCanceledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TransactionCanceledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TransactionCanceledException::builder).build());
                }
                case "InvalidExportTimeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExportTimeException::builder).build());
                }
                case "InternalServerError": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTimeToLiveRequest, this.clientConfiguration), updateTimeToLiveRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTimeToLive");
            UpdateTimeToLiveResponse updateTimeToLiveResponse = (UpdateTimeToLiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTimeToLive").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTimeToLiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTimeToLiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateTimeToLive$155((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DynamoDbWaiter waiter() {
        return DynamoDbWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "dynamodb";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        DynamoDbServiceClientConfigurationBuilder serviceConfigBuilder = new DynamoDbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DynamoDbException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    @Override
    public final DynamoDbServiceClientConfiguration serviceClientConfiguration() {
        return new DynamoDbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTimeToLive$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTableReplicaAutoScaling$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$150(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKinesisStreamingDestination$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateItem$144(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTableSettings$141(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTable$138(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContributorInsights$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContinuousBackups$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$130(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactWriteItems$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactGetItems$124(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$scan$118(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableToPointInTime$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableFromBackup$112(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$106(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putItem$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsOfResource$100(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImports$94(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGlobalTables$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExports$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContributorInsights$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBackups$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importTable$82(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getItem$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportTableToPointInTime$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeTransaction$72(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeStatement$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKinesisStreamingDestination$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKinesisStreamingDestination$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTimeToLive$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTableReplicaAutoScaling$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLimits$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKinesisStreamingDestination$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImport$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTableSettings$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTable$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExport$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContributorInsights$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContinuousBackups$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackup$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteItem$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGlobalTable$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackup$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchWriteItem$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetItem$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchExecuteStatement$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

