/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGlobalTablesRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ListGlobalTablesRequest> {
    private static final SdkField<String> EXCLUSIVE_START_GLOBAL_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusiveStartGlobalTableName").getter(ListGlobalTablesRequest.getter(ListGlobalTablesRequest::exclusiveStartGlobalTableName)).setter(ListGlobalTablesRequest.setter(Builder::exclusiveStartGlobalTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartGlobalTableName").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListGlobalTablesRequest.getter(ListGlobalTablesRequest::limit)).setter(ListGlobalTablesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(ListGlobalTablesRequest.getter(ListGlobalTablesRequest::regionName)).setter(ListGlobalTablesRequest.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSIVE_START_GLOBAL_TABLE_NAME_FIELD, LIMIT_FIELD, REGION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGlobalTablesRequest.memberNameToFieldInitializer();
    private final String exclusiveStartGlobalTableName;
    private final Integer limit;
    private final String regionName;

    private ListGlobalTablesRequest(BuilderImpl builder) {
        super(builder);
        this.exclusiveStartGlobalTableName = builder.exclusiveStartGlobalTableName;
        this.limit = builder.limit;
        this.regionName = builder.regionName;
    }

    public final String exclusiveStartGlobalTableName() {
        return this.exclusiveStartGlobalTableName;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String regionName() {
        return this.regionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartGlobalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGlobalTablesRequest)) {
            return false;
        }
        ListGlobalTablesRequest other = (ListGlobalTablesRequest)((Object)obj);
        return Objects.equals(this.exclusiveStartGlobalTableName(), other.exclusiveStartGlobalTableName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.regionName(), other.regionName());
    }

    public final String toString() {
        return ToString.builder((String)"ListGlobalTablesRequest").add("ExclusiveStartGlobalTableName", (Object)this.exclusiveStartGlobalTableName()).add("Limit", (Object)this.limit()).add("RegionName", (Object)this.regionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExclusiveStartGlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartGlobalTableName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExclusiveStartGlobalTableName", EXCLUSIVE_START_GLOBAL_TABLE_NAME_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("RegionName", REGION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGlobalTablesRequest, T> g) {
        return obj -> g.apply((ListGlobalTablesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String exclusiveStartGlobalTableName;
        private Integer limit;
        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGlobalTablesRequest model) {
            super(model);
            this.exclusiveStartGlobalTableName(model.exclusiveStartGlobalTableName);
            this.limit(model.limit);
            this.regionName(model.regionName);
        }

        public final String getExclusiveStartGlobalTableName() {
            return this.exclusiveStartGlobalTableName;
        }

        public final void setExclusiveStartGlobalTableName(String exclusiveStartGlobalTableName) {
            this.exclusiveStartGlobalTableName = exclusiveStartGlobalTableName;
        }

        @Override
        public final Builder exclusiveStartGlobalTableName(String exclusiveStartGlobalTableName) {
            this.exclusiveStartGlobalTableName = exclusiveStartGlobalTableName;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGlobalTablesRequest build() {
            return new ListGlobalTablesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGlobalTablesRequest> {
        public Builder exclusiveStartGlobalTableName(String var1);

        public Builder limit(Integer var1);

        public Builder regionName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

