/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.BackupDetails;
import software.amazon.awssdk.services.dynamodb.model.SourceTableDetails;
import software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupDescription> {
    private static final SdkField<BackupDetails> BACKUP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackupDetails").getter(BackupDescription.getter(BackupDescription::backupDetails)).setter(BackupDescription.setter(Builder::backupDetails)).constructor(BackupDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupDetails").build()}).build();
    private static final SdkField<SourceTableDetails> SOURCE_TABLE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceTableDetails").getter(BackupDescription.getter(BackupDescription::sourceTableDetails)).setter(BackupDescription.setter(Builder::sourceTableDetails)).constructor(SourceTableDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableDetails").build()}).build();
    private static final SdkField<SourceTableFeatureDetails> SOURCE_TABLE_FEATURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceTableFeatureDetails").getter(BackupDescription.getter(BackupDescription::sourceTableFeatureDetails)).setter(BackupDescription.setter(Builder::sourceTableFeatureDetails)).constructor(SourceTableFeatureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableFeatureDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_DETAILS_FIELD, SOURCE_TABLE_DETAILS_FIELD, SOURCE_TABLE_FEATURE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BackupDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BackupDetails backupDetails;
    private final SourceTableDetails sourceTableDetails;
    private final SourceTableFeatureDetails sourceTableFeatureDetails;

    private BackupDescription(BuilderImpl builder) {
        this.backupDetails = builder.backupDetails;
        this.sourceTableDetails = builder.sourceTableDetails;
        this.sourceTableFeatureDetails = builder.sourceTableFeatureDetails;
    }

    public final BackupDetails backupDetails() {
        return this.backupDetails;
    }

    public final SourceTableDetails sourceTableDetails() {
        return this.sourceTableDetails;
    }

    public final SourceTableFeatureDetails sourceTableFeatureDetails() {
        return this.sourceTableFeatureDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableFeatureDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupDescription)) {
            return false;
        }
        BackupDescription other = (BackupDescription)obj;
        return Objects.equals(this.backupDetails(), other.backupDetails()) && Objects.equals(this.sourceTableDetails(), other.sourceTableDetails()) && Objects.equals(this.sourceTableFeatureDetails(), other.sourceTableFeatureDetails());
    }

    public final String toString() {
        return ToString.builder((String)"BackupDescription").add("BackupDetails", (Object)this.backupDetails()).add("SourceTableDetails", (Object)this.sourceTableDetails()).add("SourceTableFeatureDetails", (Object)this.sourceTableFeatureDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupDetails": {
                return Optional.ofNullable(clazz.cast(this.backupDetails()));
            }
            case "SourceTableDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceTableDetails()));
            }
            case "SourceTableFeatureDetails": {
                return Optional.ofNullable(clazz.cast(this.sourceTableFeatureDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupDetails", BACKUP_DETAILS_FIELD);
        map.put("SourceTableDetails", SOURCE_TABLE_DETAILS_FIELD);
        map.put("SourceTableFeatureDetails", SOURCE_TABLE_FEATURE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackupDescription, T> g) {
        return obj -> g.apply((BackupDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BackupDetails backupDetails;
        private SourceTableDetails sourceTableDetails;
        private SourceTableFeatureDetails sourceTableFeatureDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupDescription model) {
            this.backupDetails(model.backupDetails);
            this.sourceTableDetails(model.sourceTableDetails);
            this.sourceTableFeatureDetails(model.sourceTableFeatureDetails);
        }

        public final BackupDetails.Builder getBackupDetails() {
            return this.backupDetails != null ? this.backupDetails.toBuilder() : null;
        }

        public final void setBackupDetails(BackupDetails.BuilderImpl backupDetails) {
            this.backupDetails = backupDetails != null ? backupDetails.build() : null;
        }

        @Override
        public final Builder backupDetails(BackupDetails backupDetails) {
            this.backupDetails = backupDetails;
            return this;
        }

        public final SourceTableDetails.Builder getSourceTableDetails() {
            return this.sourceTableDetails != null ? this.sourceTableDetails.toBuilder() : null;
        }

        public final void setSourceTableDetails(SourceTableDetails.BuilderImpl sourceTableDetails) {
            this.sourceTableDetails = sourceTableDetails != null ? sourceTableDetails.build() : null;
        }

        @Override
        public final Builder sourceTableDetails(SourceTableDetails sourceTableDetails) {
            this.sourceTableDetails = sourceTableDetails;
            return this;
        }

        public final SourceTableFeatureDetails.Builder getSourceTableFeatureDetails() {
            return this.sourceTableFeatureDetails != null ? this.sourceTableFeatureDetails.toBuilder() : null;
        }

        public final void setSourceTableFeatureDetails(SourceTableFeatureDetails.BuilderImpl sourceTableFeatureDetails) {
            this.sourceTableFeatureDetails = sourceTableFeatureDetails != null ? sourceTableFeatureDetails.build() : null;
        }

        @Override
        public final Builder sourceTableFeatureDetails(SourceTableFeatureDetails sourceTableFeatureDetails) {
            this.sourceTableFeatureDetails = sourceTableFeatureDetails;
            return this;
        }

        public BackupDescription build() {
            return new BackupDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupDescription> {
        public Builder backupDetails(BackupDetails var1);

        default public Builder backupDetails(Consumer<BackupDetails.Builder> backupDetails) {
            return this.backupDetails((BackupDetails)((BackupDetails.Builder)BackupDetails.builder().applyMutation(backupDetails)).build());
        }

        public Builder sourceTableDetails(SourceTableDetails var1);

        default public Builder sourceTableDetails(Consumer<SourceTableDetails.Builder> sourceTableDetails) {
            return this.sourceTableDetails((SourceTableDetails)((SourceTableDetails.Builder)SourceTableDetails.builder().applyMutation(sourceTableDetails)).build());
        }

        public Builder sourceTableFeatureDetails(SourceTableFeatureDetails var1);

        default public Builder sourceTableFeatureDetails(Consumer<SourceTableFeatureDetails.Builder> sourceTableFeatureDetails) {
            return this.sourceTableFeatureDetails((SourceTableFeatureDetails)((SourceTableFeatureDetails.Builder)SourceTableFeatureDetails.builder().applyMutation(sourceTableFeatureDetails)).build());
        }
    }
}

