/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Shard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Shard> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Shard.getter(Shard::shardId)).setter(Shard.setter(Builder::shardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()}).build();
    private static final SdkField<SequenceNumberRange> SEQUENCE_NUMBER_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Shard.getter(Shard::sequenceNumberRange)).setter(Shard.setter(Builder::sequenceNumberRange)).constructor(SequenceNumberRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumberRange").build()}).build();
    private static final SdkField<String> PARENT_SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Shard.getter(Shard::parentShardId)).setter(Shard.setter(Builder::parentShardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentShardId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD, SEQUENCE_NUMBER_RANGE_FIELD, PARENT_SHARD_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shardId;
    private final SequenceNumberRange sequenceNumberRange;
    private final String parentShardId;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.sequenceNumberRange = builder.sequenceNumberRange;
        this.parentShardId = builder.parentShardId;
    }

    public String shardId() {
        return this.shardId;
    }

    public SequenceNumberRange sequenceNumberRange() {
        return this.sequenceNumberRange;
    }

    public String parentShardId() {
        return this.parentShardId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumberRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentShardId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)obj;
        return Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.sequenceNumberRange(), other.sequenceNumberRange()) && Objects.equals(this.parentShardId(), other.parentShardId());
    }

    public String toString() {
        return ToString.builder((String)"Shard").add("ShardId", (Object)this.shardId()).add("SequenceNumberRange", (Object)this.sequenceNumberRange()).add("ParentShardId", (Object)this.parentShardId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "SequenceNumberRange": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumberRange()));
            }
            case "ParentShardId": {
                return Optional.ofNullable(clazz.cast(this.parentShardId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Shard, T> g) {
        return obj -> g.apply((Shard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shardId;
        private SequenceNumberRange sequenceNumberRange;
        private String parentShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            this.shardId(model.shardId);
            this.sequenceNumberRange(model.sequenceNumberRange);
            this.parentShardId(model.parentShardId);
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return this.sequenceNumberRange != null ? this.sequenceNumberRange.toBuilder() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        public final String getParentShardId() {
            return this.parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        public Shard build() {
            return new Shard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Shard> {
        public Builder shardId(String var1);

        public Builder sequenceNumberRange(SequenceNumberRange var1);

        default public Builder sequenceNumberRange(Consumer<SequenceNumberRange.Builder> sequenceNumberRange) {
            return this.sequenceNumberRange((SequenceNumberRange)((SequenceNumberRange.Builder)SequenceNumberRange.builder().applyMutation(sequenceNumberRange)).build());
        }

        public Builder parentShardId(String var1);
    }
}

