/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the provisioned throughput settings for the table, consisting of read and write capacity units, along with
 * data about increases and decreases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedThroughputDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedThroughputDescription.Builder, ProvisionedThroughputDescription> {
    private static final SdkField<Instant> LAST_INCREASE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastIncreaseDateTime").getter(getter(ProvisionedThroughputDescription::lastIncreaseDateTime))
            .setter(setter(Builder::lastIncreaseDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastIncreaseDateTime").build())
            .build();

    private static final SdkField<Instant> LAST_DECREASE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastDecreaseDateTime").getter(getter(ProvisionedThroughputDescription::lastDecreaseDateTime))
            .setter(setter(Builder::lastDecreaseDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDecreaseDateTime").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_DECREASES_TODAY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfDecreasesToday").getter(getter(ProvisionedThroughputDescription::numberOfDecreasesToday))
            .setter(setter(Builder::numberOfDecreasesToday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDecreasesToday").build())
            .build();

    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ReadCapacityUnits").getter(getter(ProvisionedThroughputDescription::readCapacityUnits))
            .setter(setter(Builder::readCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCapacityUnits").build()).build();

    private static final SdkField<Long> WRITE_CAPACITY_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WriteCapacityUnits").getter(getter(ProvisionedThroughputDescription::writeCapacityUnits))
            .setter(setter(Builder::writeCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LAST_INCREASE_DATE_TIME_FIELD, LAST_DECREASE_DATE_TIME_FIELD, NUMBER_OF_DECREASES_TODAY_FIELD,
                    READ_CAPACITY_UNITS_FIELD, WRITE_CAPACITY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant lastIncreaseDateTime;

    private final Instant lastDecreaseDateTime;

    private final Long numberOfDecreasesToday;

    private final Long readCapacityUnits;

    private final Long writeCapacityUnits;

    private ProvisionedThroughputDescription(BuilderImpl builder) {
        this.lastIncreaseDateTime = builder.lastIncreaseDateTime;
        this.lastDecreaseDateTime = builder.lastDecreaseDateTime;
        this.numberOfDecreasesToday = builder.numberOfDecreasesToday;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    /**
     * <p>
     * The date and time of the last provisioned throughput increase for this table.
     * </p>
     * 
     * @return The date and time of the last provisioned throughput increase for this table.
     */
    public final Instant lastIncreaseDateTime() {
        return lastIncreaseDateTime;
    }

    /**
     * <p>
     * The date and time of the last provisioned throughput decrease for this table.
     * </p>
     * 
     * @return The date and time of the last provisioned throughput decrease for this table.
     */
    public final Instant lastDecreaseDateTime() {
        return lastDecreaseDateTime;
    }

    /**
     * <p>
     * The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums
     * on provisioned throughput decreases, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
     * Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The number of provisioned throughput decreases for this table during this UTC calendar day. For current
     *         maximums on provisioned throughput decreases, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
     *         Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final Long numberOfDecreasesToday() {
        return numberOfDecreasesToday;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads,
     * so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent
     * <code>ReadCapacityUnits</code> per second.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly
     *         consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually
     *         consistent <code>ReadCapacityUnits</code> per second.
     */
    public final Long readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public final Long writeCapacityUnits() {
        return writeCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastIncreaseDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastDecreaseDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDecreasesToday());
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(writeCapacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughputDescription)) {
            return false;
        }
        ProvisionedThroughputDescription other = (ProvisionedThroughputDescription) obj;
        return Objects.equals(lastIncreaseDateTime(), other.lastIncreaseDateTime())
                && Objects.equals(lastDecreaseDateTime(), other.lastDecreaseDateTime())
                && Objects.equals(numberOfDecreasesToday(), other.numberOfDecreasesToday())
                && Objects.equals(readCapacityUnits(), other.readCapacityUnits())
                && Objects.equals(writeCapacityUnits(), other.writeCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedThroughputDescription").add("LastIncreaseDateTime", lastIncreaseDateTime())
                .add("LastDecreaseDateTime", lastDecreaseDateTime()).add("NumberOfDecreasesToday", numberOfDecreasesToday())
                .add("ReadCapacityUnits", readCapacityUnits()).add("WriteCapacityUnits", writeCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastIncreaseDateTime":
            return Optional.ofNullable(clazz.cast(lastIncreaseDateTime()));
        case "LastDecreaseDateTime":
            return Optional.ofNullable(clazz.cast(lastDecreaseDateTime()));
        case "NumberOfDecreasesToday":
            return Optional.ofNullable(clazz.cast(numberOfDecreasesToday()));
        case "ReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(readCapacityUnits()));
        case "WriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(writeCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LastIncreaseDateTime", LAST_INCREASE_DATE_TIME_FIELD);
        map.put("LastDecreaseDateTime", LAST_DECREASE_DATE_TIME_FIELD);
        map.put("NumberOfDecreasesToday", NUMBER_OF_DECREASES_TODAY_FIELD);
        map.put("ReadCapacityUnits", READ_CAPACITY_UNITS_FIELD);
        map.put("WriteCapacityUnits", WRITE_CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedThroughputDescription, T> g) {
        return obj -> g.apply((ProvisionedThroughputDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedThroughputDescription> {
        /**
         * <p>
         * The date and time of the last provisioned throughput increase for this table.
         * </p>
         * 
         * @param lastIncreaseDateTime
         *        The date and time of the last provisioned throughput increase for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastIncreaseDateTime(Instant lastIncreaseDateTime);

        /**
         * <p>
         * The date and time of the last provisioned throughput decrease for this table.
         * </p>
         * 
         * @param lastDecreaseDateTime
         *        The date and time of the last provisioned throughput decrease for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDecreaseDateTime(Instant lastDecreaseDateTime);

        /**
         * <p>
         * The number of provisioned throughput decreases for this table during this UTC calendar day. For current
         * maximums on provisioned throughput decreases, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
         * Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param numberOfDecreasesToday
         *        The number of provisioned throughput decreases for this table during this UTC calendar day. For
         *        current maximums on provisioned throughput decreases, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account,
         *        and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDecreasesToday(Long numberOfDecreasesToday);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent
         * reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent
         * <code>ReadCapacityUnits</code> per second.
         * </p>
         * 
         * @param readCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly
         *        consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually
         *        consistent <code>ReadCapacityUnits</code> per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Long readCapacityUnits);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * </p>
         * 
         * @param writeCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityUnits(Long writeCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastIncreaseDateTime;

        private Instant lastDecreaseDateTime;

        private Long numberOfDecreasesToday;

        private Long readCapacityUnits;

        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputDescription model) {
            lastIncreaseDateTime(model.lastIncreaseDateTime);
            lastDecreaseDateTime(model.lastDecreaseDateTime);
            numberOfDecreasesToday(model.numberOfDecreasesToday);
            readCapacityUnits(model.readCapacityUnits);
            writeCapacityUnits(model.writeCapacityUnits);
        }

        public final Instant getLastIncreaseDateTime() {
            return lastIncreaseDateTime;
        }

        public final void setLastIncreaseDateTime(Instant lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
        }

        @Override
        public final Builder lastIncreaseDateTime(Instant lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
            return this;
        }

        public final Instant getLastDecreaseDateTime() {
            return lastDecreaseDateTime;
        }

        public final void setLastDecreaseDateTime(Instant lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
        }

        @Override
        public final Builder lastDecreaseDateTime(Instant lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
            return this;
        }

        public final Long getNumberOfDecreasesToday() {
            return numberOfDecreasesToday;
        }

        public final void setNumberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
        }

        @Override
        public final Builder numberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
            return this;
        }

        public final Long getReadCapacityUnits() {
            return readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Long getWriteCapacityUnits() {
            return writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        @Override
        public ProvisionedThroughputDescription build() {
            return new ProvisionedThroughputDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
