/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of the point in time settings applied to the table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PointInTimeRecoveryDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PointInTimeRecoveryDescription.Builder, PointInTimeRecoveryDescription> {
    private static final SdkField<String> POINT_IN_TIME_RECOVERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PointInTimeRecoveryStatus")
            .getter(getter(PointInTimeRecoveryDescription::pointInTimeRecoveryStatusAsString))
            .setter(setter(Builder::pointInTimeRecoveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointInTimeRecoveryStatus").build())
            .build();

    private static final SdkField<Integer> RECOVERY_PERIOD_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RecoveryPeriodInDays").getter(getter(PointInTimeRecoveryDescription::recoveryPeriodInDays))
            .setter(setter(Builder::recoveryPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPeriodInDays").build())
            .build();

    private static final SdkField<Instant> EARLIEST_RESTORABLE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EarliestRestorableDateTime")
            .getter(getter(PointInTimeRecoveryDescription::earliestRestorableDateTime))
            .setter(setter(Builder::earliestRestorableDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestRestorableDateTime").build())
            .build();

    private static final SdkField<Instant> LATEST_RESTORABLE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LatestRestorableDateTime")
            .getter(getter(PointInTimeRecoveryDescription::latestRestorableDateTime))
            .setter(setter(Builder::latestRestorableDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POINT_IN_TIME_RECOVERY_STATUS_FIELD, RECOVERY_PERIOD_IN_DAYS_FIELD, EARLIEST_RESTORABLE_DATE_TIME_FIELD,
            LATEST_RESTORABLE_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pointInTimeRecoveryStatus;

    private final Integer recoveryPeriodInDays;

    private final Instant earliestRestorableDateTime;

    private final Instant latestRestorableDateTime;

    private PointInTimeRecoveryDescription(BuilderImpl builder) {
        this.pointInTimeRecoveryStatus = builder.pointInTimeRecoveryStatus;
        this.recoveryPeriodInDays = builder.recoveryPeriodInDays;
        this.earliestRestorableDateTime = builder.earliestRestorableDateTime;
        this.latestRestorableDateTime = builder.latestRestorableDateTime;
    }

    /**
     * <p>
     * The current state of point in time recovery:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Point in time recovery is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Point in time recovery is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pointInTimeRecoveryStatus} will return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pointInTimeRecoveryStatusAsString}.
     * </p>
     * 
     * @return The current state of point in time recovery:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Point in time recovery is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Point in time recovery is disabled.
     *         </p>
     *         </li>
     * @see PointInTimeRecoveryStatus
     */
    public final PointInTimeRecoveryStatus pointInTimeRecoveryStatus() {
        return PointInTimeRecoveryStatus.fromValue(pointInTimeRecoveryStatus);
    }

    /**
     * <p>
     * The current state of point in time recovery:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Point in time recovery is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - Point in time recovery is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pointInTimeRecoveryStatus} will return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pointInTimeRecoveryStatusAsString}.
     * </p>
     * 
     * @return The current state of point in time recovery:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Point in time recovery is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - Point in time recovery is disabled.
     *         </p>
     *         </li>
     * @see PointInTimeRecoveryStatus
     */
    public final String pointInTimeRecoveryStatusAsString() {
        return pointInTimeRecoveryStatus;
    }

    /**
     * <p>
     * The number of preceding days for which continuous backups are taken and maintained. Your table data is only
     * recoverable to any point-in-time from within the configured recovery period. This parameter is optional. If no
     * value is provided, the value will default to 35.
     * </p>
     * 
     * @return The number of preceding days for which continuous backups are taken and maintained. Your table data is
     *         only recoverable to any point-in-time from within the configured recovery period. This parameter is
     *         optional. If no value is provided, the value will default to 35.
     */
    public final Integer recoveryPeriodInDays() {
        return recoveryPeriodInDays;
    }

    /**
     * <p>
     * Specifies the earliest point in time you can restore your table to. You can restore your table to any point in
     * time during the last 35 days.
     * </p>
     * 
     * @return Specifies the earliest point in time you can restore your table to. You can restore your table to any
     *         point in time during the last 35 days.
     */
    public final Instant earliestRestorableDateTime() {
        return earliestRestorableDateTime;
    }

    /**
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
     * </p>
     * 
     * @return <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
     */
    public final Instant latestRestorableDateTime() {
        return latestRestorableDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(earliestRestorableDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestorableDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoveryDescription)) {
            return false;
        }
        PointInTimeRecoveryDescription other = (PointInTimeRecoveryDescription) obj;
        return Objects.equals(pointInTimeRecoveryStatusAsString(), other.pointInTimeRecoveryStatusAsString())
                && Objects.equals(recoveryPeriodInDays(), other.recoveryPeriodInDays())
                && Objects.equals(earliestRestorableDateTime(), other.earliestRestorableDateTime())
                && Objects.equals(latestRestorableDateTime(), other.latestRestorableDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PointInTimeRecoveryDescription")
                .add("PointInTimeRecoveryStatus", pointInTimeRecoveryStatusAsString())
                .add("RecoveryPeriodInDays", recoveryPeriodInDays())
                .add("EarliestRestorableDateTime", earliestRestorableDateTime())
                .add("LatestRestorableDateTime", latestRestorableDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PointInTimeRecoveryStatus":
            return Optional.ofNullable(clazz.cast(pointInTimeRecoveryStatusAsString()));
        case "RecoveryPeriodInDays":
            return Optional.ofNullable(clazz.cast(recoveryPeriodInDays()));
        case "EarliestRestorableDateTime":
            return Optional.ofNullable(clazz.cast(earliestRestorableDateTime()));
        case "LatestRestorableDateTime":
            return Optional.ofNullable(clazz.cast(latestRestorableDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PointInTimeRecoveryStatus", POINT_IN_TIME_RECOVERY_STATUS_FIELD);
        map.put("RecoveryPeriodInDays", RECOVERY_PERIOD_IN_DAYS_FIELD);
        map.put("EarliestRestorableDateTime", EARLIEST_RESTORABLE_DATE_TIME_FIELD);
        map.put("LatestRestorableDateTime", LATEST_RESTORABLE_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PointInTimeRecoveryDescription, T> g) {
        return obj -> g.apply((PointInTimeRecoveryDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PointInTimeRecoveryDescription> {
        /**
         * <p>
         * The current state of point in time recovery:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Point in time recovery is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Point in time recovery is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pointInTimeRecoveryStatus
         *        The current state of point in time recovery:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Point in time recovery is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Point in time recovery is disabled.
         *        </p>
         *        </li>
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder pointInTimeRecoveryStatus(String pointInTimeRecoveryStatus);

        /**
         * <p>
         * The current state of point in time recovery:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Point in time recovery is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - Point in time recovery is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param pointInTimeRecoveryStatus
         *        The current state of point in time recovery:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Point in time recovery is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - Point in time recovery is disabled.
         *        </p>
         *        </li>
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus pointInTimeRecoveryStatus);

        /**
         * <p>
         * The number of preceding days for which continuous backups are taken and maintained. Your table data is only
         * recoverable to any point-in-time from within the configured recovery period. This parameter is optional. If
         * no value is provided, the value will default to 35.
         * </p>
         * 
         * @param recoveryPeriodInDays
         *        The number of preceding days for which continuous backups are taken and maintained. Your table data is
         *        only recoverable to any point-in-time from within the configured recovery period. This parameter is
         *        optional. If no value is provided, the value will default to 35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPeriodInDays(Integer recoveryPeriodInDays);

        /**
         * <p>
         * Specifies the earliest point in time you can restore your table to. You can restore your table to any point
         * in time during the last 35 days.
         * </p>
         * 
         * @param earliestRestorableDateTime
         *        Specifies the earliest point in time you can restore your table to. You can restore your table to any
         *        point in time during the last 35 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestRestorableDateTime(Instant earliestRestorableDateTime);

        /**
         * <p>
         * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
         * </p>
         * 
         * @param latestRestorableDateTime
         *        <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestorableDateTime(Instant latestRestorableDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String pointInTimeRecoveryStatus;

        private Integer recoveryPeriodInDays;

        private Instant earliestRestorableDateTime;

        private Instant latestRestorableDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoveryDescription model) {
            pointInTimeRecoveryStatus(model.pointInTimeRecoveryStatus);
            recoveryPeriodInDays(model.recoveryPeriodInDays);
            earliestRestorableDateTime(model.earliestRestorableDateTime);
            latestRestorableDateTime(model.latestRestorableDateTime);
        }

        public final String getPointInTimeRecoveryStatus() {
            return pointInTimeRecoveryStatus;
        }

        public final void setPointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
            return this;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus(pointInTimeRecoveryStatus == null ? null : pointInTimeRecoveryStatus.toString());
            return this;
        }

        public final Integer getRecoveryPeriodInDays() {
            return recoveryPeriodInDays;
        }

        public final void setRecoveryPeriodInDays(Integer recoveryPeriodInDays) {
            this.recoveryPeriodInDays = recoveryPeriodInDays;
        }

        @Override
        public final Builder recoveryPeriodInDays(Integer recoveryPeriodInDays) {
            this.recoveryPeriodInDays = recoveryPeriodInDays;
            return this;
        }

        public final Instant getEarliestRestorableDateTime() {
            return earliestRestorableDateTime;
        }

        public final void setEarliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
        }

        @Override
        public final Builder earliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
            return this;
        }

        public final Instant getLatestRestorableDateTime() {
            return latestRestorableDateTime;
        }

        public final void setLatestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
        }

        @Override
        public final Builder latestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
            return this;
        }

        @Override
        public PointInTimeRecoveryDescription build() {
            return new PointInTimeRecoveryDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
