/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ListImportsResponse.Builder, ListImportsResponse> {
    private static final SdkField<List<ImportSummary>> IMPORT_SUMMARY_LIST_FIELD = SdkField
            .<List<ImportSummary>> builder(MarshallingType.LIST)
            .memberName("ImportSummaryList")
            .getter(getter(ListImportsResponse::importSummaryList))
            .setter(setter(Builder::importSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListImportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ImportSummary> importSummaryList;

    private final String nextToken;

    private ListImportsResponse(BuilderImpl builder) {
        super(builder);
        this.importSummaryList = builder.importSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportSummaryList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImportSummaryList() {
        return importSummaryList != null && !(importSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ImportSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportSummaryList} method.
     * </p>
     * 
     * @return A list of <code>ImportSummary</code> objects.
     */
    public final List<ImportSummary> importSummaryList() {
        return importSummaryList;
    }

    /**
     * <p>
     * If this value is returned, there are additional results to be displayed. To retrieve them, call
     * <code>ListImports</code> again, with <code>NextToken</code> set to this value.
     * </p>
     * 
     * @return If this value is returned, there are additional results to be displayed. To retrieve them, call
     *         <code>ListImports</code> again, with <code>NextToken</code> set to this value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImportSummaryList() ? importSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse) obj;
        return hasImportSummaryList() == other.hasImportSummaryList()
                && Objects.equals(importSummaryList(), other.importSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportsResponse")
                .add("ImportSummaryList", hasImportSummaryList() ? importSummaryList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportSummaryList":
            return Optional.ofNullable(clazz.cast(importSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImportSummaryList", IMPORT_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImportsResponse, T> g) {
        return obj -> g.apply((ListImportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImportsResponse> {
        /**
         * <p>
         * A list of <code>ImportSummary</code> objects.
         * </p>
         * 
         * @param importSummaryList
         *        A list of <code>ImportSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSummaryList(Collection<ImportSummary> importSummaryList);

        /**
         * <p>
         * A list of <code>ImportSummary</code> objects.
         * </p>
         * 
         * @param importSummaryList
         *        A list of <code>ImportSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSummaryList(ImportSummary... importSummaryList);

        /**
         * <p>
         * A list of <code>ImportSummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.ImportSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.dynamodb.model.ImportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.ImportSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #importSummaryList(List<ImportSummary>)}.
         * 
         * @param importSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.ImportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importSummaryList(java.util.Collection<ImportSummary>)
         */
        Builder importSummaryList(Consumer<ImportSummary.Builder>... importSummaryList);

        /**
         * <p>
         * If this value is returned, there are additional results to be displayed. To retrieve them, call
         * <code>ListImports</code> again, with <code>NextToken</code> set to this value.
         * </p>
         * 
         * @param nextToken
         *        If this value is returned, there are additional results to be displayed. To retrieve them, call
         *        <code>ListImports</code> again, with <code>NextToken</code> set to this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<ImportSummary> importSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            super(model);
            importSummaryList(model.importSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ImportSummary.Builder> getImportSummaryList() {
            List<ImportSummary.Builder> result = ImportSummaryListCopier.copyToBuilder(this.importSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportSummaryList(Collection<ImportSummary.BuilderImpl> importSummaryList) {
            this.importSummaryList = ImportSummaryListCopier.copyFromBuilder(importSummaryList);
        }

        @Override
        public final Builder importSummaryList(Collection<ImportSummary> importSummaryList) {
            this.importSummaryList = ImportSummaryListCopier.copy(importSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSummaryList(ImportSummary... importSummaryList) {
            importSummaryList(Arrays.asList(importSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSummaryList(Consumer<ImportSummary.Builder>... importSummaryList) {
            importSummaryList(Stream.of(importSummaryList).map(c -> ImportSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
