/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.endpoints;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The parameters object used to resolve an endpoint for the DynamoDb service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class DynamoDbEndpointParams implements ToCopyableBuilder<DynamoDbEndpointParams.Builder, DynamoDbEndpointParams> {
    private final Region region;

    private final Boolean useDualStack;

    private final Boolean useFIPS;

    private final String endpoint;

    private final String accountId;

    private final String accountIdEndpointMode;

    private DynamoDbEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useDualStack = builder.useDualStack;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.accountId = builder.accountId;
        this.accountIdEndpointMode = builder.accountIdEndpointMode;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return region;
    }

    public Boolean useDualStack() {
        return useDualStack;
    }

    public Boolean useFips() {
        return useFIPS;
    }

    public String endpoint() {
        return endpoint;
    }

    public String accountId() {
        return accountId;
    }

    public String accountIdEndpointMode() {
        return accountIdEndpointMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public interface Builder extends CopyableBuilder<Builder, DynamoDbEndpointParams> {
        Builder region(Region region);

        Builder useDualStack(Boolean useDualStack);

        Builder useFips(Boolean useFIPS);

        Builder endpoint(String endpoint);

        Builder accountId(String accountId);

        Builder accountIdEndpointMode(String accountIdEndpointMode);

        DynamoDbEndpointParams build();
    }

    private static class BuilderImpl implements Builder {
        private Region region;

        private Boolean useDualStack = false;

        private Boolean useFIPS = false;

        private String endpoint;

        private String accountId;

        private String accountIdEndpointMode;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDbEndpointParams builder) {
            this.region = builder.region;
            this.useDualStack = builder.useDualStack;
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.accountId = builder.accountId;
            this.accountIdEndpointMode = builder.accountIdEndpointMode;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @Override
        public Builder accountIdEndpointMode(String accountIdEndpointMode) {
            this.accountIdEndpointMode = accountIdEndpointMode;
            return this;
        }

        @Override
        public DynamoDbEndpointParams build() {
            return new DynamoDbEndpointParams(this);
        }
    }
}
