/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.TableClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReplicationGroupMemberAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateReplicationGroupMemberAction> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(UpdateReplicationGroupMemberAction.getter(UpdateReplicationGroupMemberAction::regionName)).setter(UpdateReplicationGroupMemberAction.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSMasterKeyId").getter(UpdateReplicationGroupMemberAction.getter(UpdateReplicationGroupMemberAction::kmsMasterKeyId)).setter(UpdateReplicationGroupMemberAction.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()}).build();
    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(UpdateReplicationGroupMemberAction.getter(UpdateReplicationGroupMemberAction::provisionedThroughputOverride)).setter(UpdateReplicationGroupMemberAction.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<OnDemandThroughputOverride> ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandThroughputOverride").getter(UpdateReplicationGroupMemberAction.getter(UpdateReplicationGroupMemberAction::onDemandThroughputOverride)).setter(UpdateReplicationGroupMemberAction.setter(Builder::onDemandThroughputOverride)).constructor(OnDemandThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughputOverride").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(UpdateReplicationGroupMemberAction.getter(UpdateReplicationGroupMemberAction::globalSecondaryIndexes)).setter(UpdateReplicationGroupMemberAction.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_CLASS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableClassOverride").getter(UpdateReplicationGroupMemberAction.getter(UpdateReplicationGroupMemberAction::tableClassOverrideAsString)).setter(UpdateReplicationGroupMemberAction.setter(Builder::tableClassOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClassOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, TABLE_CLASS_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateReplicationGroupMemberAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String kmsMasterKeyId;
    private final ProvisionedThroughputOverride provisionedThroughputOverride;
    private final OnDemandThroughputOverride onDemandThroughputOverride;
    private final List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes;
    private final String tableClassOverride;

    private UpdateReplicationGroupMemberAction(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.onDemandThroughputOverride = builder.onDemandThroughputOverride;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.tableClassOverride = builder.tableClassOverride;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public final ProvisionedThroughputOverride provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public final OnDemandThroughputOverride onDemandThroughputOverride() {
        return this.onDemandThroughputOverride;
    }

    public final boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public final List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public final TableClass tableClassOverride() {
        return TableClass.fromValue(this.tableClassOverride);
    }

    public final String tableClassOverrideAsString() {
        return this.tableClassOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableClassOverrideAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationGroupMemberAction)) {
            return false;
        }
        UpdateReplicationGroupMemberAction other = (UpdateReplicationGroupMemberAction)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.onDemandThroughputOverride(), other.onDemandThroughputOverride()) && this.hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes() && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.tableClassOverrideAsString(), other.tableClassOverrideAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReplicationGroupMemberAction").add("RegionName", (Object)this.regionName()).add("KMSMasterKeyId", (Object)this.kmsMasterKeyId()).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("OnDemandThroughputOverride", (Object)this.onDemandThroughputOverride()).add("GlobalSecondaryIndexes", this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null).add("TableClassOverride", (Object)this.tableClassOverrideAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "KMSMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "OnDemandThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.onDemandThroughputOverride()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "TableClassOverride": {
                return Optional.ofNullable(clazz.cast(this.tableClassOverrideAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("KMSMasterKeyId", KMS_MASTER_KEY_ID_FIELD);
        map.put("ProvisionedThroughputOverride", PROVISIONED_THROUGHPUT_OVERRIDE_FIELD);
        map.put("OnDemandThroughputOverride", ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD);
        map.put("GlobalSecondaryIndexes", GLOBAL_SECONDARY_INDEXES_FIELD);
        map.put("TableClassOverride", TABLE_CLASS_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationGroupMemberAction, T> g) {
        return obj -> g.apply((UpdateReplicationGroupMemberAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String kmsMasterKeyId;
        private ProvisionedThroughputOverride provisionedThroughputOverride;
        private OnDemandThroughputOverride onDemandThroughputOverride;
        private List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private String tableClassOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationGroupMemberAction model) {
            this.regionName(model.regionName);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.onDemandThroughputOverride(model.onDemandThroughputOverride);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.tableClassOverride(model.tableClassOverride);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final OnDemandThroughputOverride.Builder getOnDemandThroughputOverride() {
            return this.onDemandThroughputOverride != null ? this.onDemandThroughputOverride.toBuilder() : null;
        }

        public final void setOnDemandThroughputOverride(OnDemandThroughputOverride.BuilderImpl onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride != null ? onDemandThroughputOverride.build() : null;
        }

        @Override
        public final Builder onDemandThroughputOverride(OnDemandThroughputOverride onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<ReplicaGlobalSecondaryIndex.Builder> result = ReplicaGlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (ReplicaGlobalSecondaryIndex)((ReplicaGlobalSecondaryIndex.Builder)ReplicaGlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTableClassOverride() {
            return this.tableClassOverride;
        }

        public final void setTableClassOverride(String tableClassOverride) {
            this.tableClassOverride = tableClassOverride;
        }

        @Override
        public final Builder tableClassOverride(String tableClassOverride) {
            this.tableClassOverride = tableClassOverride;
            return this;
        }

        @Override
        public final Builder tableClassOverride(TableClass tableClassOverride) {
            this.tableClassOverride(tableClassOverride == null ? null : tableClassOverride.toString());
            return this;
        }

        public UpdateReplicationGroupMemberAction build() {
            return new UpdateReplicationGroupMemberAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateReplicationGroupMemberAction> {
        public Builder regionName(String var1);

        public Builder kmsMasterKeyId(String var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughputOverride var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughputOverride)((ProvisionedThroughputOverride.Builder)ProvisionedThroughputOverride.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder onDemandThroughputOverride(OnDemandThroughputOverride var1);

        default public Builder onDemandThroughputOverride(Consumer<OnDemandThroughputOverride.Builder> onDemandThroughputOverride) {
            return this.onDemandThroughputOverride((OnDemandThroughputOverride)((OnDemandThroughputOverride.Builder)OnDemandThroughputOverride.builder().applyMutation(onDemandThroughputOverride)).build());
        }

        public Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder> ... var1);

        public Builder tableClassOverride(String var1);

        public Builder tableClassOverride(TableClass var1);
    }
}

