/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the amount of provisioned throughput capacity consumed on a table or an index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Capacity implements SdkPojo, Serializable, ToCopyableBuilder<Capacity.Builder, Capacity> {
    private static final SdkField<Double> READ_CAPACITY_UNITS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ReadCapacityUnits").getter(getter(Capacity::readCapacityUnits))
            .setter(setter(Builder::readCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadCapacityUnits").build()).build();

    private static final SdkField<Double> WRITE_CAPACITY_UNITS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("WriteCapacityUnits").getter(getter(Capacity::writeCapacityUnits))
            .setter(setter(Builder::writeCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCapacityUnits").build())
            .build();

    private static final SdkField<Double> CAPACITY_UNITS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("CapacityUnits").getter(getter(Capacity::capacityUnits)).setter(setter(Builder::capacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_CAPACITY_UNITS_FIELD,
            WRITE_CAPACITY_UNITS_FIELD, CAPACITY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double readCapacityUnits;

    private final Double writeCapacityUnits;

    private final Double capacityUnits;

    private Capacity(BuilderImpl builder) {
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
        this.capacityUnits = builder.capacityUnits;
    }

    /**
     * <p>
     * The total number of read capacity units consumed on a table or an index.
     * </p>
     * 
     * @return The total number of read capacity units consumed on a table or an index.
     */
    public final Double readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The total number of write capacity units consumed on a table or an index.
     * </p>
     * 
     * @return The total number of write capacity units consumed on a table or an index.
     */
    public final Double writeCapacityUnits() {
        return writeCapacityUnits;
    }

    /**
     * <p>
     * The total number of capacity units consumed on a table or an index.
     * </p>
     * 
     * @return The total number of capacity units consumed on a table or an index.
     */
    public final Double capacityUnits() {
        return capacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(writeCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(capacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity) obj;
        return Objects.equals(readCapacityUnits(), other.readCapacityUnits())
                && Objects.equals(writeCapacityUnits(), other.writeCapacityUnits())
                && Objects.equals(capacityUnits(), other.capacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Capacity").add("ReadCapacityUnits", readCapacityUnits())
                .add("WriteCapacityUnits", writeCapacityUnits()).add("CapacityUnits", capacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadCapacityUnits":
            return Optional.ofNullable(clazz.cast(readCapacityUnits()));
        case "WriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(writeCapacityUnits()));
        case "CapacityUnits":
            return Optional.ofNullable(clazz.cast(capacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReadCapacityUnits", READ_CAPACITY_UNITS_FIELD);
        map.put("WriteCapacityUnits", WRITE_CAPACITY_UNITS_FIELD);
        map.put("CapacityUnits", CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Capacity, T> g) {
        return obj -> g.apply((Capacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Capacity> {
        /**
         * <p>
         * The total number of read capacity units consumed on a table or an index.
         * </p>
         * 
         * @param readCapacityUnits
         *        The total number of read capacity units consumed on a table or an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Double readCapacityUnits);

        /**
         * <p>
         * The total number of write capacity units consumed on a table or an index.
         * </p>
         * 
         * @param writeCapacityUnits
         *        The total number of write capacity units consumed on a table or an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityUnits(Double writeCapacityUnits);

        /**
         * <p>
         * The total number of capacity units consumed on a table or an index.
         * </p>
         * 
         * @param capacityUnits
         *        The total number of capacity units consumed on a table or an index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityUnits(Double capacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Double readCapacityUnits;

        private Double writeCapacityUnits;

        private Double capacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(Capacity model) {
            readCapacityUnits(model.readCapacityUnits);
            writeCapacityUnits(model.writeCapacityUnits);
            capacityUnits(model.capacityUnits);
        }

        public final Double getReadCapacityUnits() {
            return readCapacityUnits;
        }

        public final void setReadCapacityUnits(Double readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Double readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Double getWriteCapacityUnits() {
            return writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Double writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Double writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final Double getCapacityUnits() {
            return capacityUnits;
        }

        public final void setCapacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
        }

        @Override
        public final Builder capacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        @Override
        public Capacity build() {
            return new Capacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
