/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLimitsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, DescribeLimitsResponse> {
    private static final SdkField<Long> ACCOUNT_MAX_READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AccountMaxReadCapacityUnits").getter(DescribeLimitsResponse.getter(DescribeLimitsResponse::accountMaxReadCapacityUnits)).setter(DescribeLimitsResponse.setter(Builder::accountMaxReadCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountMaxReadCapacityUnits").build()}).build();
    private static final SdkField<Long> ACCOUNT_MAX_WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AccountMaxWriteCapacityUnits").getter(DescribeLimitsResponse.getter(DescribeLimitsResponse::accountMaxWriteCapacityUnits)).setter(DescribeLimitsResponse.setter(Builder::accountMaxWriteCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountMaxWriteCapacityUnits").build()}).build();
    private static final SdkField<Long> TABLE_MAX_READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TableMaxReadCapacityUnits").getter(DescribeLimitsResponse.getter(DescribeLimitsResponse::tableMaxReadCapacityUnits)).setter(DescribeLimitsResponse.setter(Builder::tableMaxReadCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMaxReadCapacityUnits").build()}).build();
    private static final SdkField<Long> TABLE_MAX_WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TableMaxWriteCapacityUnits").getter(DescribeLimitsResponse.getter(DescribeLimitsResponse::tableMaxWriteCapacityUnits)).setter(DescribeLimitsResponse.setter(Builder::tableMaxWriteCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMaxWriteCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_MAX_READ_CAPACITY_UNITS_FIELD, ACCOUNT_MAX_WRITE_CAPACITY_UNITS_FIELD, TABLE_MAX_READ_CAPACITY_UNITS_FIELD, TABLE_MAX_WRITE_CAPACITY_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountMaxReadCapacityUnits", ACCOUNT_MAX_READ_CAPACITY_UNITS_FIELD);
            this.put("AccountMaxWriteCapacityUnits", ACCOUNT_MAX_WRITE_CAPACITY_UNITS_FIELD);
            this.put("TableMaxReadCapacityUnits", TABLE_MAX_READ_CAPACITY_UNITS_FIELD);
            this.put("TableMaxWriteCapacityUnits", TABLE_MAX_WRITE_CAPACITY_UNITS_FIELD);
        }
    });
    private final Long accountMaxReadCapacityUnits;
    private final Long accountMaxWriteCapacityUnits;
    private final Long tableMaxReadCapacityUnits;
    private final Long tableMaxWriteCapacityUnits;

    private DescribeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.accountMaxReadCapacityUnits = builder.accountMaxReadCapacityUnits;
        this.accountMaxWriteCapacityUnits = builder.accountMaxWriteCapacityUnits;
        this.tableMaxReadCapacityUnits = builder.tableMaxReadCapacityUnits;
        this.tableMaxWriteCapacityUnits = builder.tableMaxWriteCapacityUnits;
    }

    public final Long accountMaxReadCapacityUnits() {
        return this.accountMaxReadCapacityUnits;
    }

    public final Long accountMaxWriteCapacityUnits() {
        return this.accountMaxWriteCapacityUnits;
    }

    public final Long tableMaxReadCapacityUnits() {
        return this.tableMaxReadCapacityUnits;
    }

    public final Long tableMaxWriteCapacityUnits() {
        return this.tableMaxWriteCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountMaxWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMaxWriteCapacityUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse)((Object)obj);
        return Objects.equals(this.accountMaxReadCapacityUnits(), other.accountMaxReadCapacityUnits()) && Objects.equals(this.accountMaxWriteCapacityUnits(), other.accountMaxWriteCapacityUnits()) && Objects.equals(this.tableMaxReadCapacityUnits(), other.tableMaxReadCapacityUnits()) && Objects.equals(this.tableMaxWriteCapacityUnits(), other.tableMaxWriteCapacityUnits());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLimitsResponse").add("AccountMaxReadCapacityUnits", (Object)this.accountMaxReadCapacityUnits()).add("AccountMaxWriteCapacityUnits", (Object)this.accountMaxWriteCapacityUnits()).add("TableMaxReadCapacityUnits", (Object)this.tableMaxReadCapacityUnits()).add("TableMaxWriteCapacityUnits", (Object)this.tableMaxWriteCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountMaxReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.accountMaxReadCapacityUnits()));
            }
            case "AccountMaxWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.accountMaxWriteCapacityUnits()));
            }
            case "TableMaxReadCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.tableMaxReadCapacityUnits()));
            }
            case "TableMaxWriteCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.tableMaxWriteCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLimitsResponse, T> g) {
        return obj -> g.apply((DescribeLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private Long accountMaxReadCapacityUnits;
        private Long accountMaxWriteCapacityUnits;
        private Long tableMaxReadCapacityUnits;
        private Long tableMaxWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            super(model);
            this.accountMaxReadCapacityUnits(model.accountMaxReadCapacityUnits);
            this.accountMaxWriteCapacityUnits(model.accountMaxWriteCapacityUnits);
            this.tableMaxReadCapacityUnits(model.tableMaxReadCapacityUnits);
            this.tableMaxWriteCapacityUnits(model.tableMaxWriteCapacityUnits);
        }

        public final Long getAccountMaxReadCapacityUnits() {
            return this.accountMaxReadCapacityUnits;
        }

        public final void setAccountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
        }

        @Override
        public final Builder accountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
            return this;
        }

        public final Long getAccountMaxWriteCapacityUnits() {
            return this.accountMaxWriteCapacityUnits;
        }

        public final void setAccountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
        }

        @Override
        public final Builder accountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
            return this;
        }

        public final Long getTableMaxReadCapacityUnits() {
            return this.tableMaxReadCapacityUnits;
        }

        public final void setTableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
        }

        @Override
        public final Builder tableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
            return this;
        }

        public final Long getTableMaxWriteCapacityUnits() {
            return this.tableMaxWriteCapacityUnits;
        }

        public final void setTableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
        }

        @Override
        public final Builder tableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
            return this;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLimitsResponse> {
        public Builder accountMaxReadCapacityUnits(Long var1);

        public Builder accountMaxWriteCapacityUnits(Long var1);

        public Builder tableMaxReadCapacityUnits(Long var1);

        public Builder tableMaxWriteCapacityUnits(Long var1);
    }
}

