/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.ContributorInsightsSummariesCopier;
import software.amazon.awssdk.services.dynamodb.model.ContributorInsightsSummary;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContributorInsightsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ListContributorInsightsResponse> {
    private static final SdkField<List<ContributorInsightsSummary>> CONTRIBUTOR_INSIGHTS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributorInsightsSummaries").getter(ListContributorInsightsResponse.getter(ListContributorInsightsResponse::contributorInsightsSummaries)).setter(ListContributorInsightsResponse.setter(Builder::contributorInsightsSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContributorInsightsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContributorInsightsResponse.getter(ListContributorInsightsResponse::nextToken)).setter(ListContributorInsightsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRIBUTOR_INSIGHTS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContributorInsightsSummaries", CONTRIBUTOR_INSIGHTS_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ContributorInsightsSummary> contributorInsightsSummaries;
    private final String nextToken;

    private ListContributorInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.contributorInsightsSummaries = builder.contributorInsightsSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContributorInsightsSummaries() {
        return this.contributorInsightsSummaries != null && !(this.contributorInsightsSummaries instanceof SdkAutoConstructList);
    }

    public final List<ContributorInsightsSummary> contributorInsightsSummaries() {
        return this.contributorInsightsSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributorInsightsSummaries() ? this.contributorInsightsSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContributorInsightsResponse)) {
            return false;
        }
        ListContributorInsightsResponse other = (ListContributorInsightsResponse)((Object)obj);
        return this.hasContributorInsightsSummaries() == other.hasContributorInsightsSummaries() && Objects.equals(this.contributorInsightsSummaries(), other.contributorInsightsSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContributorInsightsResponse").add("ContributorInsightsSummaries", this.hasContributorInsightsSummaries() ? this.contributorInsightsSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContributorInsightsSummaries": {
                return Optional.ofNullable(clazz.cast(this.contributorInsightsSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListContributorInsightsResponse, T> g) {
        return obj -> g.apply((ListContributorInsightsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<ContributorInsightsSummary> contributorInsightsSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContributorInsightsResponse model) {
            super(model);
            this.contributorInsightsSummaries(model.contributorInsightsSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ContributorInsightsSummary.Builder> getContributorInsightsSummaries() {
            List<ContributorInsightsSummary.Builder> result = ContributorInsightsSummariesCopier.copyToBuilder(this.contributorInsightsSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributorInsightsSummaries(Collection<ContributorInsightsSummary.BuilderImpl> contributorInsightsSummaries) {
            this.contributorInsightsSummaries = ContributorInsightsSummariesCopier.copyFromBuilder(contributorInsightsSummaries);
        }

        @Override
        public final Builder contributorInsightsSummaries(Collection<ContributorInsightsSummary> contributorInsightsSummaries) {
            this.contributorInsightsSummaries = ContributorInsightsSummariesCopier.copy(contributorInsightsSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorInsightsSummaries(ContributorInsightsSummary ... contributorInsightsSummaries) {
            this.contributorInsightsSummaries(Arrays.asList(contributorInsightsSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorInsightsSummaries(Consumer<ContributorInsightsSummary.Builder> ... contributorInsightsSummaries) {
            this.contributorInsightsSummaries(Stream.of(contributorInsightsSummaries).map(c -> (ContributorInsightsSummary)((ContributorInsightsSummary.Builder)ContributorInsightsSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContributorInsightsResponse build() {
            return new ListContributorInsightsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContributorInsightsResponse> {
        public Builder contributorInsightsSummaries(Collection<ContributorInsightsSummary> var1);

        public Builder contributorInsightsSummaries(ContributorInsightsSummary ... var1);

        public Builder contributorInsightsSummaries(Consumer<ContributorInsightsSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

