/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of an <code>UpdateTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateTableRequest.Builder, UpdateTableRequest> {
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<AttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("AttributeDefinitions")
            .getter(getter(UpdateTableRequest::attributeDefinitions))
            .setter(setter(Builder::attributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateTableRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingMode").getter(getter(UpdateTableRequest::billingModeAsString))
            .setter(setter(Builder::billingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(UpdateTableRequest::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<List<GlobalSecondaryIndexUpdate>> GLOBAL_SECONDARY_INDEX_UPDATES_FIELD = SdkField
            .<List<GlobalSecondaryIndexUpdate>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexUpdates")
            .getter(getter(UpdateTableRequest::globalSecondaryIndexUpdates))
            .setter(setter(Builder::globalSecondaryIndexUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexUpdates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalSecondaryIndexUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalSecondaryIndexUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField
            .<StreamSpecification> builder(MarshallingType.SDK_POJO).memberName("StreamSpecification")
            .getter(getter(UpdateTableRequest::streamSpecification)).setter(setter(Builder::streamSpecification))
            .constructor(StreamSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build())
            .build();

    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField
            .<SSESpecification> builder(MarshallingType.SDK_POJO).memberName("SSESpecification")
            .getter(getter(UpdateTableRequest::sseSpecification)).setter(setter(Builder::sseSpecification))
            .constructor(SSESpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()).build();

    private static final SdkField<List<ReplicationGroupUpdate>> REPLICA_UPDATES_FIELD = SdkField
            .<List<ReplicationGroupUpdate>> builder(MarshallingType.LIST)
            .memberName("ReplicaUpdates")
            .getter(getter(UpdateTableRequest::replicaUpdates))
            .setter(setter(Builder::replicaUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationGroupUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationGroupUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TABLE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableClass").getter(getter(UpdateTableRequest::tableClassAsString)).setter(setter(Builder::tableClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableClass").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled")
            .getter(getter(UpdateTableRequest::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build())
            .build();

    private static final SdkField<OnDemandThroughput> ON_DEMAND_THROUGHPUT_FIELD = SdkField
            .<OnDemandThroughput> builder(MarshallingType.SDK_POJO).memberName("OnDemandThroughput")
            .getter(getter(UpdateTableRequest::onDemandThroughput)).setter(setter(Builder::onDemandThroughput))
            .constructor(OnDemandThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughput").build())
            .build();

    private static final SdkField<WarmThroughput> WARM_THROUGHPUT_FIELD = SdkField
            .<WarmThroughput> builder(MarshallingType.SDK_POJO).memberName("WarmThroughput")
            .getter(getter(UpdateTableRequest::warmThroughput)).setter(setter(Builder::warmThroughput))
            .constructor(WarmThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD,
            TABLE_NAME_FIELD, BILLING_MODE_FIELD, PROVISIONED_THROUGHPUT_FIELD, GLOBAL_SECONDARY_INDEX_UPDATES_FIELD,
            STREAM_SPECIFICATION_FIELD, SSE_SPECIFICATION_FIELD, REPLICA_UPDATES_FIELD, TABLE_CLASS_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD, ON_DEMAND_THROUGHPUT_FIELD, WARM_THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AttributeDefinitions", ATTRIBUTE_DEFINITIONS_FIELD);
                    put("TableName", TABLE_NAME_FIELD);
                    put("BillingMode", BILLING_MODE_FIELD);
                    put("ProvisionedThroughput", PROVISIONED_THROUGHPUT_FIELD);
                    put("GlobalSecondaryIndexUpdates", GLOBAL_SECONDARY_INDEX_UPDATES_FIELD);
                    put("StreamSpecification", STREAM_SPECIFICATION_FIELD);
                    put("SSESpecification", SSE_SPECIFICATION_FIELD);
                    put("ReplicaUpdates", REPLICA_UPDATES_FIELD);
                    put("TableClass", TABLE_CLASS_FIELD);
                    put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
                    put("OnDemandThroughput", ON_DEMAND_THROUGHPUT_FIELD);
                    put("WarmThroughput", WARM_THROUGHPUT_FIELD);
                }
            });

    private final List<AttributeDefinition> attributeDefinitions;

    private final String tableName;

    private final String billingMode;

    private final ProvisionedThroughput provisionedThroughput;

    private final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates;

    private final StreamSpecification streamSpecification;

    private final SSESpecification sseSpecification;

    private final List<ReplicationGroupUpdate> replicaUpdates;

    private final String tableClass;

    private final Boolean deletionProtectionEnabled;

    private final OnDemandThroughput onDemandThroughput;

    private final WarmThroughput warmThroughput;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.billingMode = builder.billingMode;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.streamSpecification = builder.streamSpecification;
        this.sseSpecification = builder.sseSpecification;
        this.replicaUpdates = builder.replicaUpdates;
        this.tableClass = builder.tableClass;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.onDemandThroughput = builder.onDemandThroughput;
        this.warmThroughput = builder.warmThroughput;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeDefinitions() {
        return attributeDefinitions != null && !(attributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
     * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeDefinitions} method.
     * </p>
     * 
     * @return An array of attributes that describe the key schema for the table and indexes. If you are adding a new
     *         global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of
     *         the new index.
     */
    public final List<AttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * The name of the table to be updated. You can also provide the Amazon Resource Name (ARN) of the table in this
     * parameter.
     * </p>
     * 
     * @return The name of the table to be updated. You can also provide the Amazon Resource Name (ARN) of the table in
     *         this parameter.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. When switching from
     * pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned
     * capacity values are estimated based on the consumed read and write capacity of your table and global secondary
     * indexes over the past 30 minutes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     * <code>PROVISIONED</code> sets the billing mode to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
     * >Provisioned capacity mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html">On-demand
     * capacity mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. When switching
     *         from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The
     *         initial provisioned capacity values are estimated based on the consumed read and write capacity of your
     *         table and global secondary indexes over the past 30 minutes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     *         <code>PROVISIONED</code> sets the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
     *         >Provisioned capacity mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
     *         >On-demand capacity mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public final BillingMode billingMode() {
        return BillingMode.fromValue(billingMode);
    }

    /**
     * <p>
     * Controls how you are charged for read and write throughput and how you manage capacity. When switching from
     * pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial provisioned
     * capacity values are estimated based on the consumed read and write capacity of your table and global secondary
     * indexes over the past 30 minutes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     * <code>PROVISIONED</code> sets the billing mode to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
     * >Provisioned capacity mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html">On-demand
     * capacity mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingMode} will
     * return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #billingModeAsString}.
     * </p>
     * 
     * @return Controls how you are charged for read and write throughput and how you manage capacity. When switching
     *         from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The
     *         initial provisioned capacity values are estimated based on the consumed read and write capacity of your
     *         table and global secondary indexes over the past 30 minutes.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     *         <code>PROVISIONED</code> sets the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
     *         >Provisioned capacity mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
     *         >On-demand capacity mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public final String billingModeAsString() {
        return billingMode;
    }

    /**
     * <p>
     * The new provisioned throughput settings for the specified table or index.
     * </p>
     * 
     * @return The new provisioned throughput settings for the specified table or index.
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexUpdates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexUpdates() {
        return globalSecondaryIndexUpdates != null && !(globalSecondaryIndexUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of one or more global secondary indexes for the table. For each index in the array, you can request one
     * action:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Create</code> - add a new global secondary index to the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delete</code> - remove a global secondary index from the table.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create or delete only one global secondary index per <code>UpdateTable</code> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
     * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexUpdates} method.
     * </p>
     * 
     * @return An array of one or more global secondary indexes for the table. For each index in the array, you can
     *         request one action:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Create</code> - add a new global secondary index to the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Delete</code> - remove a global secondary index from the table.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can create or delete only one global secondary index per <code>UpdateTable</code> operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing
     *         Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates() {
        return globalSecondaryIndexUpdates;
    }

    /**
     * <p>
     * Represents the DynamoDB Streams configuration for the table.
     * </p>
     * <note>
     * <p>
     * You receive a <code>ValidationException</code> if you try to enable a stream on a table that already has a
     * stream, or if you try to disable a stream on a table that doesn't have a stream.
     * </p>
     * </note>
     * 
     * @return Represents the DynamoDB Streams configuration for the table.</p> <note>
     *         <p>
     *         You receive a <code>ValidationException</code> if you try to enable a stream on a table that already has
     *         a stream, or if you try to disable a stream on a table that doesn't have a stream.
     *         </p>
     */
    public final StreamSpecification streamSpecification() {
        return streamSpecification;
    }

    /**
     * <p>
     * The new server-side encryption settings for the specified table.
     * </p>
     * 
     * @return The new server-side encryption settings for the specified table.
     */
    public final SSESpecification sseSpecification() {
        return sseSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicaUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicaUpdates() {
        return replicaUpdates != null && !(replicaUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of replica update actions (create, delete, or update) for the table.
     * </p>
     * <note>
     * <p>
     * For global tables, this property only applies to global tables using Version 2019.11.21 (Current version).
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicaUpdates} method.
     * </p>
     * 
     * @return A list of replica update actions (create, delete, or update) for the table.</p> <note>
     *         <p>
     *         For global tables, this property only applies to global tables using Version 2019.11.21 (Current
     *         version).
     *         </p>
     */
    public final List<ReplicationGroupUpdate> replicaUpdates() {
        return replicaUpdates;
    }

    /**
     * <p>
     * The table class of the table to be updated. Valid values are <code>STANDARD</code> and
     * <code>STANDARD_INFREQUENT_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableClass} will
     * return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableClassAsString}.
     * </p>
     * 
     * @return The table class of the table to be updated. Valid values are <code>STANDARD</code> and
     *         <code>STANDARD_INFREQUENT_ACCESS</code>.
     * @see TableClass
     */
    public final TableClass tableClass() {
        return TableClass.fromValue(tableClass);
    }

    /**
     * <p>
     * The table class of the table to be updated. Valid values are <code>STANDARD</code> and
     * <code>STANDARD_INFREQUENT_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tableClass} will
     * return {@link TableClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tableClassAsString}.
     * </p>
     * 
     * @return The table class of the table to be updated. Valid values are <code>STANDARD</code> and
     *         <code>STANDARD_INFREQUENT_ACCESS</code>.
     * @see TableClass
     */
    public final String tableClassAsString() {
        return tableClass;
    }

    /**
     * <p>
     * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
     * </p>
     * 
     * @return Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * Updates the maximum number of read and write units for the specified table in on-demand capacity mode. If you use
     * this parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or both.
     * </p>
     * 
     * @return Updates the maximum number of read and write units for the specified table in on-demand capacity mode. If
     *         you use this parameter, you must specify <code>MaxReadRequestUnits</code>,
     *         <code>MaxWriteRequestUnits</code>, or both.
     */
    public final OnDemandThroughput onDemandThroughput() {
        return onDemandThroughput;
    }

    /**
     * <p>
     * Represents the warm throughput (in read units per second and write units per second) for updating a table.
     * </p>
     * 
     * @return Represents the warm throughput (in read units per second and write units per second) for updating a
     *         table.
     */
    public final WarmThroughput warmThroughput() {
        return warmThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeDefinitions() ? attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexUpdates() ? globalSecondaryIndexUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicaUpdates() ? replicaUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(warmThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest) obj;
        return hasAttributeDefinitions() == other.hasAttributeDefinitions()
                && Objects.equals(attributeDefinitions(), other.attributeDefinitions())
                && Objects.equals(tableName(), other.tableName())
                && Objects.equals(billingModeAsString(), other.billingModeAsString())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && hasGlobalSecondaryIndexUpdates() == other.hasGlobalSecondaryIndexUpdates()
                && Objects.equals(globalSecondaryIndexUpdates(), other.globalSecondaryIndexUpdates())
                && Objects.equals(streamSpecification(), other.streamSpecification())
                && Objects.equals(sseSpecification(), other.sseSpecification())
                && hasReplicaUpdates() == other.hasReplicaUpdates() && Objects.equals(replicaUpdates(), other.replicaUpdates())
                && Objects.equals(tableClassAsString(), other.tableClassAsString())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(onDemandThroughput(), other.onDemandThroughput())
                && Objects.equals(warmThroughput(), other.warmThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableRequest")
                .add("AttributeDefinitions", hasAttributeDefinitions() ? attributeDefinitions() : null)
                .add("TableName", tableName()).add("BillingMode", billingModeAsString())
                .add("ProvisionedThroughput", provisionedThroughput())
                .add("GlobalSecondaryIndexUpdates", hasGlobalSecondaryIndexUpdates() ? globalSecondaryIndexUpdates() : null)
                .add("StreamSpecification", streamSpecification()).add("SSESpecification", sseSpecification())
                .add("ReplicaUpdates", hasReplicaUpdates() ? replicaUpdates() : null).add("TableClass", tableClassAsString())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled()).add("OnDemandThroughput", onDemandThroughput())
                .add("WarmThroughput", warmThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeDefinitions":
            return Optional.ofNullable(clazz.cast(attributeDefinitions()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "BillingMode":
            return Optional.ofNullable(clazz.cast(billingModeAsString()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "GlobalSecondaryIndexUpdates":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexUpdates()));
        case "StreamSpecification":
            return Optional.ofNullable(clazz.cast(streamSpecification()));
        case "SSESpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        case "ReplicaUpdates":
            return Optional.ofNullable(clazz.cast(replicaUpdates()));
        case "TableClass":
            return Optional.ofNullable(clazz.cast(tableClassAsString()));
        case "DeletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "OnDemandThroughput":
            return Optional.ofNullable(clazz.cast(onDemandThroughput()));
        case "WarmThroughput":
            return Optional.ofNullable(clazz.cast(warmThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTableRequest> {
        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes. If you are adding a new
         *        global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s)
         *        of the new index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * 
         * @param attributeDefinitions
         *        An array of attributes that describe the key schema for the table and indexes. If you are adding a new
         *        global secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s)
         *        of the new index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * An array of attributes that describe the key schema for the table and indexes. If you are adding a new global
         * secondary index to the table, <code>AttributeDefinitions</code> must include the key element(s) of the new
         * index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeDefinitions(List<AttributeDefinition>)}.
         * 
         * @param attributeDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.AttributeDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinitions(java.util.Collection<AttributeDefinition>)
         */
        Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions);

        /**
         * <p>
         * The name of the table to be updated. You can also provide the Amazon Resource Name (ARN) of the table in this
         * parameter.
         * </p>
         * 
         * @param tableName
         *        The name of the table to be updated. You can also provide the Amazon Resource Name (ARN) of the table
         *        in this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. When switching from
         * pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial
         * provisioned capacity values are estimated based on the consumed read and write capacity of your table and
         * global secondary indexes over the past 30 minutes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         * <code>PROVISIONED</code> sets the billing mode to <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
         * >Provisioned capacity mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         * >On-demand capacity mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. When switching
         *        from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The
         *        initial provisioned capacity values are estimated based on the consumed read and write capacity of
         *        your table and global secondary indexes over the past 30 minutes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         *        <code>PROVISIONED</code> sets the billing mode to <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
         *        >Provisioned capacity mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         *        >On-demand capacity mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(String billingMode);

        /**
         * <p>
         * Controls how you are charged for read and write throughput and how you manage capacity. When switching from
         * pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The initial
         * provisioned capacity values are estimated based on the consumed read and write capacity of your table and
         * global secondary indexes over the past 30 minutes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         * <code>PROVISIONED</code> sets the billing mode to <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
         * >Provisioned capacity mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         * >On-demand capacity mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param billingMode
         *        Controls how you are charged for read and write throughput and how you manage capacity. When switching
         *        from pay-per-request to provisioned capacity, initial provisioned capacity values must be set. The
         *        initial provisioned capacity values are estimated based on the consumed read and write capacity of
         *        your table and global secondary indexes over the past 30 minutes.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         *        <code>PROVISIONED</code> sets the billing mode to <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html"
         *        >Provisioned capacity mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html"
         *        >On-demand capacity mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder billingMode(BillingMode billingMode);

        /**
         * <p>
         * The new provisioned throughput settings for the specified table or index.
         * </p>
         * 
         * @param provisionedThroughput
         *        The new provisioned throughput settings for the specified table or index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * The new provisioned throughput settings for the specified table or index.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can create or delete only one global secondary index per <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        An array of one or more global secondary indexes for the table. For each index in the array, you can
         *        request one action:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Create</code> - add a new global secondary index to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Update</code> - modify the provisioned throughput settings of an existing global secondary
         *        index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delete</code> - remove a global secondary index from the table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can create or delete only one global secondary index per <code>UpdateTable</code> operation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing
         *        Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates);

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can create or delete only one global secondary index per <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param globalSecondaryIndexUpdates
         *        An array of one or more global secondary indexes for the table. For each index in the array, you can
         *        request one action:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Create</code> - add a new global secondary index to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Update</code> - modify the provisioned throughput settings of an existing global secondary
         *        index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delete</code> - remove a global secondary index from the table.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can create or delete only one global secondary index per <code>UpdateTable</code> operation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing
         *        Global Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate... globalSecondaryIndexUpdates);

        /**
         * <p>
         * An array of one or more global secondary indexes for the table. For each index in the array, you can request
         * one action:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Create</code> - add a new global secondary index to the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Update</code> - modify the provisioned throughput settings of an existing global secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delete</code> - remove a global secondary index from the table.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can create or delete only one global secondary index per <code>UpdateTable</code> operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html">Managing Global
         * Secondary Indexes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #globalSecondaryIndexUpdates(List<GlobalSecondaryIndexUpdate>)}.
         * 
         * @param globalSecondaryIndexUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexUpdates(java.util.Collection<GlobalSecondaryIndexUpdate>)
         */
        Builder globalSecondaryIndexUpdates(Consumer<GlobalSecondaryIndexUpdate.Builder>... globalSecondaryIndexUpdates);

        /**
         * <p>
         * Represents the DynamoDB Streams configuration for the table.
         * </p>
         * <note>
         * <p>
         * You receive a <code>ValidationException</code> if you try to enable a stream on a table that already has a
         * stream, or if you try to disable a stream on a table that doesn't have a stream.
         * </p>
         * </note>
         * 
         * @param streamSpecification
         *        Represents the DynamoDB Streams configuration for the table.</p> <note>
         *        <p>
         *        You receive a <code>ValidationException</code> if you try to enable a stream on a table that already
         *        has a stream, or if you try to disable a stream on a table that doesn't have a stream.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(StreamSpecification streamSpecification);

        /**
         * <p>
         * Represents the DynamoDB Streams configuration for the table.
         * </p>
         * <note>
         * <p>
         * You receive a <code>ValidationException</code> if you try to enable a stream on a table that already has a
         * stream, or if you try to disable a stream on a table that doesn't have a stream.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StreamSpecification.Builder}
         * avoiding the need to create one manually via {@link StreamSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #streamSpecification(StreamSpecification)}.
         * 
         * @param streamSpecification
         *        a consumer that will call methods on {@link StreamSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSpecification(StreamSpecification)
         */
        default Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return streamSpecification(StreamSpecification.builder().applyMutation(streamSpecification).build());
        }

        /**
         * <p>
         * The new server-side encryption settings for the specified table.
         * </p>
         * 
         * @param sseSpecification
         *        The new server-side encryption settings for the specified table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(SSESpecification sseSpecification);

        /**
         * <p>
         * The new server-side encryption settings for the specified table.
         * </p>
         * This is a convenience method that creates an instance of the {@link SSESpecification.Builder} avoiding the
         * need to create one manually via {@link SSESpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SSESpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #sseSpecification(SSESpecification)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link SSESpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(SSESpecification)
         */
        default Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return sseSpecification(SSESpecification.builder().applyMutation(sseSpecification).build());
        }

        /**
         * <p>
         * A list of replica update actions (create, delete, or update) for the table.
         * </p>
         * <note>
         * <p>
         * For global tables, this property only applies to global tables using Version 2019.11.21 (Current version).
         * </p>
         * </note>
         * 
         * @param replicaUpdates
         *        A list of replica update actions (create, delete, or update) for the table.</p> <note>
         *        <p>
         *        For global tables, this property only applies to global tables using Version 2019.11.21 (Current
         *        version).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaUpdates(Collection<ReplicationGroupUpdate> replicaUpdates);

        /**
         * <p>
         * A list of replica update actions (create, delete, or update) for the table.
         * </p>
         * <note>
         * <p>
         * For global tables, this property only applies to global tables using Version 2019.11.21 (Current version).
         * </p>
         * </note>
         * 
         * @param replicaUpdates
         *        A list of replica update actions (create, delete, or update) for the table.</p> <note>
         *        <p>
         *        For global tables, this property only applies to global tables using Version 2019.11.21 (Current
         *        version).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaUpdates(ReplicationGroupUpdate... replicaUpdates);

        /**
         * <p>
         * A list of replica update actions (create, delete, or update) for the table.
         * </p>
         * <note>
         * <p>
         * For global tables, this property only applies to global tables using Version 2019.11.21 (Current version).
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaUpdates(List<ReplicationGroupUpdate>)}.
         * 
         * @param replicaUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaUpdates(java.util.Collection<ReplicationGroupUpdate>)
         */
        Builder replicaUpdates(Consumer<ReplicationGroupUpdate.Builder>... replicaUpdates);

        /**
         * <p>
         * The table class of the table to be updated. Valid values are <code>STANDARD</code> and
         * <code>STANDARD_INFREQUENT_ACCESS</code>.
         * </p>
         * 
         * @param tableClass
         *        The table class of the table to be updated. Valid values are <code>STANDARD</code> and
         *        <code>STANDARD_INFREQUENT_ACCESS</code>.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClass(String tableClass);

        /**
         * <p>
         * The table class of the table to be updated. Valid values are <code>STANDARD</code> and
         * <code>STANDARD_INFREQUENT_ACCESS</code>.
         * </p>
         * 
         * @param tableClass
         *        The table class of the table to be updated. Valid values are <code>STANDARD</code> and
         *        <code>STANDARD_INFREQUENT_ACCESS</code>.
         * @see TableClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableClass
         */
        Builder tableClass(TableClass tableClass);

        /**
         * <p>
         * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * Updates the maximum number of read and write units for the specified table in on-demand capacity mode. If you
         * use this parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or
         * both.
         * </p>
         * 
         * @param onDemandThroughput
         *        Updates the maximum number of read and write units for the specified table in on-demand capacity mode.
         *        If you use this parameter, you must specify <code>MaxReadRequestUnits</code>,
         *        <code>MaxWriteRequestUnits</code>, or both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandThroughput(OnDemandThroughput onDemandThroughput);

        /**
         * <p>
         * Updates the maximum number of read and write units for the specified table in on-demand capacity mode. If you
         * use this parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or
         * both.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnDemandThroughput.Builder} avoiding the
         * need to create one manually via {@link OnDemandThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDemandThroughput.Builder#build()} is called immediately and its
         * result is passed to {@link #onDemandThroughput(OnDemandThroughput)}.
         * 
         * @param onDemandThroughput
         *        a consumer that will call methods on {@link OnDemandThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandThroughput(OnDemandThroughput)
         */
        default Builder onDemandThroughput(Consumer<OnDemandThroughput.Builder> onDemandThroughput) {
            return onDemandThroughput(OnDemandThroughput.builder().applyMutation(onDemandThroughput).build());
        }

        /**
         * <p>
         * Represents the warm throughput (in read units per second and write units per second) for updating a table.
         * </p>
         * 
         * @param warmThroughput
         *        Represents the warm throughput (in read units per second and write units per second) for updating a
         *        table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmThroughput(WarmThroughput warmThroughput);

        /**
         * <p>
         * Represents the warm throughput (in read units per second and write units per second) for updating a table.
         * </p>
         * This is a convenience method that creates an instance of the {@link WarmThroughput.Builder} avoiding the need
         * to create one manually via {@link WarmThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WarmThroughput.Builder#build()} is called immediately and its
         * result is passed to {@link #warmThroughput(WarmThroughput)}.
         * 
         * @param warmThroughput
         *        a consumer that will call methods on {@link WarmThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmThroughput(WarmThroughput)
         */
        default Builder warmThroughput(Consumer<WarmThroughput.Builder> warmThroughput) {
            return warmThroughput(WarmThroughput.builder().applyMutation(warmThroughput).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String tableName;

        private String billingMode;

        private ProvisionedThroughput provisionedThroughput;

        private List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates = DefaultSdkAutoConstructList.getInstance();

        private StreamSpecification streamSpecification;

        private SSESpecification sseSpecification;

        private List<ReplicationGroupUpdate> replicaUpdates = DefaultSdkAutoConstructList.getInstance();

        private String tableClass;

        private Boolean deletionProtectionEnabled;

        private OnDemandThroughput onDemandThroughput;

        private WarmThroughput warmThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            attributeDefinitions(model.attributeDefinitions);
            tableName(model.tableName);
            billingMode(model.billingMode);
            provisionedThroughput(model.provisionedThroughput);
            globalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            streamSpecification(model.streamSpecification);
            sseSpecification(model.sseSpecification);
            replicaUpdates(model.replicaUpdates);
            tableClass(model.tableClass);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            onDemandThroughput(model.onDemandThroughput);
            warmThroughput(model.warmThroughput);
        }

        public final List<AttributeDefinition.Builder> getAttributeDefinitions() {
            List<AttributeDefinition.Builder> result = AttributeDefinitionsCopier.copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder>... attributeDefinitions) {
            attributeDefinitions(Stream.of(attributeDefinitions).map(c -> AttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getBillingMode() {
            return billingMode;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final List<GlobalSecondaryIndexUpdate.Builder> getGlobalSecondaryIndexUpdates() {
            List<GlobalSecondaryIndexUpdate.Builder> result = GlobalSecondaryIndexUpdateListCopier
                    .copyToBuilder(this.globalSecondaryIndexUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexUpdates(
                Collection<GlobalSecondaryIndexUpdate.BuilderImpl> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copyFromBuilder(globalSecondaryIndexUpdates);
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexUpdate... globalSecondaryIndexUpdates) {
            globalSecondaryIndexUpdates(Arrays.asList(globalSecondaryIndexUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(
                Consumer<GlobalSecondaryIndexUpdate.Builder>... globalSecondaryIndexUpdates) {
            globalSecondaryIndexUpdates(Stream.of(globalSecondaryIndexUpdates)
                    .map(c -> GlobalSecondaryIndexUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return streamSpecification != null ? streamSpecification.toBuilder() : null;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final SSESpecification.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final List<ReplicationGroupUpdate.Builder> getReplicaUpdates() {
            List<ReplicationGroupUpdate.Builder> result = ReplicationGroupUpdateListCopier.copyToBuilder(this.replicaUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaUpdates(Collection<ReplicationGroupUpdate.BuilderImpl> replicaUpdates) {
            this.replicaUpdates = ReplicationGroupUpdateListCopier.copyFromBuilder(replicaUpdates);
        }

        @Override
        public final Builder replicaUpdates(Collection<ReplicationGroupUpdate> replicaUpdates) {
            this.replicaUpdates = ReplicationGroupUpdateListCopier.copy(replicaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(ReplicationGroupUpdate... replicaUpdates) {
            replicaUpdates(Arrays.asList(replicaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(Consumer<ReplicationGroupUpdate.Builder>... replicaUpdates) {
            replicaUpdates(Stream.of(replicaUpdates).map(c -> ReplicationGroupUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTableClass() {
            return tableClass;
        }

        public final void setTableClass(String tableClass) {
            this.tableClass = tableClass;
        }

        @Override
        public final Builder tableClass(String tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        @Override
        public final Builder tableClass(TableClass tableClass) {
            this.tableClass(tableClass == null ? null : tableClass.toString());
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final OnDemandThroughput.Builder getOnDemandThroughput() {
            return onDemandThroughput != null ? onDemandThroughput.toBuilder() : null;
        }

        public final void setOnDemandThroughput(OnDemandThroughput.BuilderImpl onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput != null ? onDemandThroughput.build() : null;
        }

        @Override
        public final Builder onDemandThroughput(OnDemandThroughput onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput;
            return this;
        }

        public final WarmThroughput.Builder getWarmThroughput() {
            return warmThroughput != null ? warmThroughput.toBuilder() : null;
        }

        public final void setWarmThroughput(WarmThroughput.BuilderImpl warmThroughput) {
            this.warmThroughput = warmThroughput != null ? warmThroughput.build() : null;
        }

        @Override
        public final Builder warmThroughput(WarmThroughput warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
