/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the global table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalTableDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalTableDescription.Builder, GlobalTableDescription> {
    private static final SdkField<List<ReplicaDescription>> REPLICATION_GROUP_FIELD = SdkField
            .<List<ReplicaDescription>> builder(MarshallingType.LIST)
            .memberName("ReplicationGroup")
            .getter(getter(GlobalTableDescription::replicationGroup))
            .setter(setter(Builder::replicationGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GLOBAL_TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableArn").getter(getter(GlobalTableDescription::globalTableArn))
            .setter(setter(Builder::globalTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDateTime").getter(getter(GlobalTableDescription::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final SdkField<String> GLOBAL_TABLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableStatus").getter(getter(GlobalTableDescription::globalTableStatusAsString))
            .setter(setter(Builder::globalTableStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableStatus").build()).build();

    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableName").getter(getter(GlobalTableDescription::globalTableName))
            .setter(setter(Builder::globalTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_FIELD,
            GLOBAL_TABLE_ARN_FIELD, CREATION_DATE_TIME_FIELD, GLOBAL_TABLE_STATUS_FIELD, GLOBAL_TABLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ReplicationGroup", REPLICATION_GROUP_FIELD);
                    put("GlobalTableArn", GLOBAL_TABLE_ARN_FIELD);
                    put("CreationDateTime", CREATION_DATE_TIME_FIELD);
                    put("GlobalTableStatus", GLOBAL_TABLE_STATUS_FIELD);
                    put("GlobalTableName", GLOBAL_TABLE_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<ReplicaDescription> replicationGroup;

    private final String globalTableArn;

    private final Instant creationDateTime;

    private final String globalTableStatus;

    private final String globalTableName;

    private GlobalTableDescription(BuilderImpl builder) {
        this.replicationGroup = builder.replicationGroup;
        this.globalTableArn = builder.globalTableArn;
        this.creationDateTime = builder.creationDateTime;
        this.globalTableStatus = builder.globalTableStatus;
        this.globalTableName = builder.globalTableName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationGroup property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationGroup() {
        return replicationGroup != null && !(replicationGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Regions where the global table has replicas.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationGroup} method.
     * </p>
     * 
     * @return The Regions where the global table has replicas.
     */
    public final List<ReplicaDescription> replicationGroup() {
        return replicationGroup;
    }

    /**
     * <p>
     * The unique identifier of the global table.
     * </p>
     * 
     * @return The unique identifier of the global table.
     */
    public final String globalTableArn() {
        return globalTableArn;
    }

    /**
     * <p>
     * The creation time of the global table.
     * </p>
     * 
     * @return The creation time of the global table.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The current state of the global table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The global table is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The global table is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The global table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The global table is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #globalTableStatus}
     * will return {@link GlobalTableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #globalTableStatusAsString}.
     * </p>
     * 
     * @return The current state of the global table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The global table is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The global table is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The global table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The global table is ready for use.
     *         </p>
     *         </li>
     * @see GlobalTableStatus
     */
    public final GlobalTableStatus globalTableStatus() {
        return GlobalTableStatus.fromValue(globalTableStatus);
    }

    /**
     * <p>
     * The current state of the global table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The global table is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The global table is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The global table is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The global table is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #globalTableStatus}
     * will return {@link GlobalTableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #globalTableStatusAsString}.
     * </p>
     * 
     * @return The current state of the global table:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The global table is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The global table is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The global table is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The global table is ready for use.
     *         </p>
     *         </li>
     * @see GlobalTableStatus
     */
    public final String globalTableStatusAsString() {
        return globalTableStatus;
    }

    /**
     * <p>
     * The global table name.
     * </p>
     * 
     * @return The global table name.
     */
    public final String globalTableName() {
        return globalTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationGroup() ? replicationGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(globalTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableDescription)) {
            return false;
        }
        GlobalTableDescription other = (GlobalTableDescription) obj;
        return hasReplicationGroup() == other.hasReplicationGroup()
                && Objects.equals(replicationGroup(), other.replicationGroup())
                && Objects.equals(globalTableArn(), other.globalTableArn())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(globalTableStatusAsString(), other.globalTableStatusAsString())
                && Objects.equals(globalTableName(), other.globalTableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalTableDescription")
                .add("ReplicationGroup", hasReplicationGroup() ? replicationGroup() : null)
                .add("GlobalTableArn", globalTableArn()).add("CreationDateTime", creationDateTime())
                .add("GlobalTableStatus", globalTableStatusAsString()).add("GlobalTableName", globalTableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroup":
            return Optional.ofNullable(clazz.cast(replicationGroup()));
        case "GlobalTableArn":
            return Optional.ofNullable(clazz.cast(globalTableArn()));
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "GlobalTableStatus":
            return Optional.ofNullable(clazz.cast(globalTableStatusAsString()));
        case "GlobalTableName":
            return Optional.ofNullable(clazz.cast(globalTableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlobalTableDescription, T> g) {
        return obj -> g.apply((GlobalTableDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalTableDescription> {
        /**
         * <p>
         * The Regions where the global table has replicas.
         * </p>
         * 
         * @param replicationGroup
         *        The Regions where the global table has replicas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroup(Collection<ReplicaDescription> replicationGroup);

        /**
         * <p>
         * The Regions where the global table has replicas.
         * </p>
         * 
         * @param replicationGroup
         *        The Regions where the global table has replicas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroup(ReplicaDescription... replicationGroup);

        /**
         * <p>
         * The Regions where the global table has replicas.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.ReplicaDescription.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dynamodb.model.ReplicaDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.ReplicaDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationGroup(List<ReplicaDescription>)}.
         * 
         * @param replicationGroup
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.ReplicaDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationGroup(java.util.Collection<ReplicaDescription>)
         */
        Builder replicationGroup(Consumer<ReplicaDescription.Builder>... replicationGroup);

        /**
         * <p>
         * The unique identifier of the global table.
         * </p>
         * 
         * @param globalTableArn
         *        The unique identifier of the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableArn(String globalTableArn);

        /**
         * <p>
         * The creation time of the global table.
         * </p>
         * 
         * @param creationDateTime
         *        The creation time of the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The current state of the global table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The global table is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The global table is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The global table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The global table is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalTableStatus
         *        The current state of the global table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The global table is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The global table is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The global table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The global table is ready for use.
         *        </p>
         *        </li>
         * @see GlobalTableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalTableStatus
         */
        Builder globalTableStatus(String globalTableStatus);

        /**
         * <p>
         * The current state of the global table:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The global table is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The global table is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The global table is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The global table is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalTableStatus
         *        The current state of the global table:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The global table is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The global table is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The global table is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The global table is ready for use.
         *        </p>
         *        </li>
         * @see GlobalTableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalTableStatus
         */
        Builder globalTableStatus(GlobalTableStatus globalTableStatus);

        /**
         * <p>
         * The global table name.
         * </p>
         * 
         * @param globalTableName
         *        The global table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableName(String globalTableName);
    }

    static final class BuilderImpl implements Builder {
        private List<ReplicaDescription> replicationGroup = DefaultSdkAutoConstructList.getInstance();

        private String globalTableArn;

        private Instant creationDateTime;

        private String globalTableStatus;

        private String globalTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableDescription model) {
            replicationGroup(model.replicationGroup);
            globalTableArn(model.globalTableArn);
            creationDateTime(model.creationDateTime);
            globalTableStatus(model.globalTableStatus);
            globalTableName(model.globalTableName);
        }

        public final List<ReplicaDescription.Builder> getReplicationGroup() {
            List<ReplicaDescription.Builder> result = ReplicaDescriptionListCopier.copyToBuilder(this.replicationGroup);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationGroup(Collection<ReplicaDescription.BuilderImpl> replicationGroup) {
            this.replicationGroup = ReplicaDescriptionListCopier.copyFromBuilder(replicationGroup);
        }

        @Override
        public final Builder replicationGroup(Collection<ReplicaDescription> replicationGroup) {
            this.replicationGroup = ReplicaDescriptionListCopier.copy(replicationGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(ReplicaDescription... replicationGroup) {
            replicationGroup(Arrays.asList(replicationGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Consumer<ReplicaDescription.Builder>... replicationGroup) {
            replicationGroup(Stream.of(replicationGroup).map(c -> ReplicaDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGlobalTableArn() {
            return globalTableArn;
        }

        public final void setGlobalTableArn(String globalTableArn) {
            this.globalTableArn = globalTableArn;
        }

        @Override
        public final Builder globalTableArn(String globalTableArn) {
            this.globalTableArn = globalTableArn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getGlobalTableStatus() {
            return globalTableStatus;
        }

        public final void setGlobalTableStatus(String globalTableStatus) {
            this.globalTableStatus = globalTableStatus;
        }

        @Override
        public final Builder globalTableStatus(String globalTableStatus) {
            this.globalTableStatus = globalTableStatus;
            return this;
        }

        @Override
        public final Builder globalTableStatus(GlobalTableStatus globalTableStatus) {
            this.globalTableStatus(globalTableStatus == null ? null : globalTableStatus.toString());
            return this;
        }

        public final String getGlobalTableName() {
            return globalTableName;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        @Override
        public GlobalTableDescription build() {
            return new GlobalTableDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
