/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchivalSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchivalSummary> {
    private static final SdkField<Instant> ARCHIVAL_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ArchivalDateTime").getter(ArchivalSummary.getter(ArchivalSummary::archivalDateTime)).setter(ArchivalSummary.setter(Builder::archivalDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalDateTime").build()}).build();
    private static final SdkField<String> ARCHIVAL_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchivalReason").getter(ArchivalSummary.getter(ArchivalSummary::archivalReason)).setter(ArchivalSummary.setter(Builder::archivalReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalReason").build()}).build();
    private static final SdkField<String> ARCHIVAL_BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchivalBackupArn").getter(ArchivalSummary.getter(ArchivalSummary::archivalBackupArn)).setter(ArchivalSummary.setter(Builder::archivalBackupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalBackupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVAL_DATE_TIME_FIELD, ARCHIVAL_REASON_FIELD, ARCHIVAL_BACKUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ArchivalDateTime", ARCHIVAL_DATE_TIME_FIELD);
            this.put("ArchivalReason", ARCHIVAL_REASON_FIELD);
            this.put("ArchivalBackupArn", ARCHIVAL_BACKUP_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant archivalDateTime;
    private final String archivalReason;
    private final String archivalBackupArn;

    private ArchivalSummary(BuilderImpl builder) {
        this.archivalDateTime = builder.archivalDateTime;
        this.archivalReason = builder.archivalReason;
        this.archivalBackupArn = builder.archivalBackupArn;
    }

    public final Instant archivalDateTime() {
        return this.archivalDateTime;
    }

    public final String archivalReason() {
        return this.archivalReason;
    }

    public final String archivalBackupArn() {
        return this.archivalBackupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archivalDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.archivalReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.archivalBackupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchivalSummary)) {
            return false;
        }
        ArchivalSummary other = (ArchivalSummary)obj;
        return Objects.equals(this.archivalDateTime(), other.archivalDateTime()) && Objects.equals(this.archivalReason(), other.archivalReason()) && Objects.equals(this.archivalBackupArn(), other.archivalBackupArn());
    }

    public final String toString() {
        return ToString.builder((String)"ArchivalSummary").add("ArchivalDateTime", (Object)this.archivalDateTime()).add("ArchivalReason", (Object)this.archivalReason()).add("ArchivalBackupArn", (Object)this.archivalBackupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchivalDateTime": {
                return Optional.ofNullable(clazz.cast(this.archivalDateTime()));
            }
            case "ArchivalReason": {
                return Optional.ofNullable(clazz.cast(this.archivalReason()));
            }
            case "ArchivalBackupArn": {
                return Optional.ofNullable(clazz.cast(this.archivalBackupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ArchivalSummary, T> g) {
        return obj -> g.apply((ArchivalSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant archivalDateTime;
        private String archivalReason;
        private String archivalBackupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchivalSummary model) {
            this.archivalDateTime(model.archivalDateTime);
            this.archivalReason(model.archivalReason);
            this.archivalBackupArn(model.archivalBackupArn);
        }

        public final Instant getArchivalDateTime() {
            return this.archivalDateTime;
        }

        public final void setArchivalDateTime(Instant archivalDateTime) {
            this.archivalDateTime = archivalDateTime;
        }

        @Override
        public final Builder archivalDateTime(Instant archivalDateTime) {
            this.archivalDateTime = archivalDateTime;
            return this;
        }

        public final String getArchivalReason() {
            return this.archivalReason;
        }

        public final void setArchivalReason(String archivalReason) {
            this.archivalReason = archivalReason;
        }

        @Override
        public final Builder archivalReason(String archivalReason) {
            this.archivalReason = archivalReason;
            return this;
        }

        public final String getArchivalBackupArn() {
            return this.archivalBackupArn;
        }

        public final void setArchivalBackupArn(String archivalBackupArn) {
            this.archivalBackupArn = archivalBackupArn;
        }

        @Override
        public final Builder archivalBackupArn(String archivalBackupArn) {
            this.archivalBackupArn = archivalBackupArn;
            return this;
        }

        public ArchivalSummary build() {
            return new ArchivalSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchivalSummary> {
        public Builder archivalDateTime(Instant var1);

        public Builder archivalReason(String var1);

        public Builder archivalBackupArn(String var1);
    }
}

