/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourcePolicyResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DeleteResourcePolicyResponse.Builder, DeleteResourcePolicyResponse> {
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(DeleteResourcePolicyResponse::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_ID_FIELD));

    private final String revisionId;

    private DeleteResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * A unique string that represents the revision ID of the policy. If you're comparing revision IDs, make sure to
     * always use string comparison logic.
     * </p>
     * <p>
     * This value will be empty if you make a request against a resource without a policy.
     * </p>
     * 
     * @return A unique string that represents the revision ID of the policy. If you're comparing revision IDs, make
     *         sure to always use string comparison logic.</p>
     *         <p>
     *         This value will be empty if you make a request against a resource without a policy.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourcePolicyResponse)) {
            return false;
        }
        DeleteResourcePolicyResponse other = (DeleteResourcePolicyResponse) obj;
        return Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourcePolicyResponse").add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourcePolicyResponse, T> g) {
        return obj -> g.apply((DeleteResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteResourcePolicyResponse> {
        /**
         * <p>
         * A unique string that represents the revision ID of the policy. If you're comparing revision IDs, make sure to
         * always use string comparison logic.
         * </p>
         * <p>
         * This value will be empty if you make a request against a resource without a policy.
         * </p>
         * 
         * @param revisionId
         *        A unique string that represents the revision ID of the policy. If you're comparing revision IDs, make
         *        sure to always use string comparison logic.</p>
         *        <p>
         *        This value will be empty if you make a request against a resource without a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourcePolicyResponse model) {
            super(model);
            revisionId(model.revisionId);
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public DeleteResourcePolicyResponse build() {
            return new DeleteResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
