/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsBaseClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsServiceClientConfiguration;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.DynamoDbStreamsEndpointProvider;

@SdkInternalApi
final class DefaultDynamoDbStreamsClientBuilder
extends DefaultDynamoDbStreamsBaseClientBuilder<DynamoDbStreamsClientBuilder, DynamoDbStreamsClient>
implements DynamoDbStreamsClientBuilder {
    DefaultDynamoDbStreamsClientBuilder() {
    }

    @Override
    public DefaultDynamoDbStreamsClientBuilder endpointProvider(DynamoDbStreamsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DynamoDbStreamsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDynamoDbStreamsClientBuilder.validateClientOptions(clientConfiguration);
        DynamoDbStreamsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDynamoDbStreamsClient client = new DefaultDynamoDbStreamsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DynamoDbStreamsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DynamoDbStreamsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

