/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.dynamodb.model.BackupInUseException;
import software.amazon.awssdk.services.dynamodb.model.BackupNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DuplicateItemException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ExportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.ImportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ImportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ImportTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ImportTableResponse;
import software.amazon.awssdk.services.dynamodb.model.IndexNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.InvalidExportTimeException;
import software.amazon.awssdk.services.dynamodb.model.InvalidRestoreTimeException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListImportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListImportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.ReplicaNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.TableInUseException;
import software.amazon.awssdk.services.dynamodb.model.TableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TransactionInProgressException;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ListExportsIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ListImportsIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ListTablesIterable;
import software.amazon.awssdk.services.dynamodb.paginators.QueryIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ScanIterable;
import software.amazon.awssdk.services.dynamodb.transform.BatchExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchGetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchWriteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeExportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeImportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeLimitsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DisableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.EnableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteTransactionRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExportTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ImportTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListGlobalTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTagsOfResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableFromBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ScanRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactGetItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactWriteItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDynamoDbClient
implements DynamoDbClient {
    private static final Logger log = Logger.loggerFor(DefaultDynamoDbClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultDynamoDbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)DynamoDbEndpointDiscoveryCacheLoader.create(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchExecuteStatementResponse batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest) throws RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchExecuteStatementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, batchExecuteStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchExecuteStatement");
            BatchExecuteStatementResponse batchExecuteStatementResponse = (BatchExecuteStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchExecuteStatement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchExecuteStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchExecuteStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$batchExecuteStatement$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetItemResponse batchGetItem(BatchGetItemRequest batchGetItemRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = batchGetItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)batchGetItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, batchGetItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetItem");
            BatchGetItemResponse batchGetItemResponse = (BatchGetItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)batchGetItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$batchGetItem$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public BatchGetItemIterable batchGetItemPaginator(BatchGetItemRequest batchGetItemRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return new BatchGetItemIterable(this, this.applyPaginatorUserAgent(batchGetItemRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchWriteItemResponse batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchWriteItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = batchWriteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)batchWriteItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, batchWriteItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchWriteItem");
            BatchWriteItemResponse batchWriteItemResponse = (BatchWriteItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchWriteItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)batchWriteItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchWriteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchWriteItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$batchWriteItem$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws TableNotFoundException, TableInUseException, ContinuousBackupsUnavailableException, BackupInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = createBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, createBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackup");
            CreateBackupResponse createBackupResponse = (CreateBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$createBackup$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGlobalTableResponse createGlobalTable(CreateGlobalTableRequest createGlobalTableRequest) throws LimitExceededException, InternalServerErrorException, GlobalTableAlreadyExistsException, TableNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGlobalTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = createGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createGlobalTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, createGlobalTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGlobalTable");
            CreateGlobalTableResponse createGlobalTableResponse = (CreateGlobalTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGlobalTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createGlobalTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGlobalTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$createGlobalTable$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws ResourceInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = createTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, createTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            CreateTableResponse createTableResponse = (CreateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$createTable$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws BackupNotFoundException, BackupInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = deleteBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            DeleteBackupResponse deleteBackupResponse = (DeleteBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$deleteBackup$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteItemResponse deleteItem(DeleteItemRequest deleteItemRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = deleteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, deleteItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteItem");
            DeleteItemResponse deleteItemResponse = (DeleteItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$deleteItem$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = deleteTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            DeleteTableResponse deleteTableResponse = (DeleteTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$deleteTable$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupResponse describeBackup(DescribeBackupRequest describeBackupRequest) throws BackupNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackup");
            DescribeBackupResponse describeBackupResponse = (DescribeBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeBackup$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContinuousBackupsResponse describeContinuousBackups(DescribeContinuousBackupsRequest describeContinuousBackupsRequest) throws TableNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContinuousBackupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeContinuousBackupsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContinuousBackups");
            DescribeContinuousBackupsResponse describeContinuousBackupsResponse = (DescribeContinuousBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContinuousBackups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeContinuousBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeContinuousBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeContinuousBackups$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContributorInsightsResponse describeContributorInsights(DescribeContributorInsightsRequest describeContributorInsightsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContributorInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContributorInsights");
            DescribeContributorInsightsResponse describeContributorInsightsResponse = (DescribeContributorInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContributorInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeContributorInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeContributorInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeContributorInsights$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            DescribeEndpointsResponse describeEndpointsResponse = (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeEndpoints$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExportResponse describeExport(DescribeExportRequest describeExportRequest) throws ExportNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExport");
            DescribeExportResponse describeExportResponse = (DescribeExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeExport$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGlobalTableResponse describeGlobalTable(DescribeGlobalTableRequest describeGlobalTableRequest) throws InternalServerErrorException, GlobalTableNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeGlobalTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTable");
            DescribeGlobalTableResponse describeGlobalTableResponse = (DescribeGlobalTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeGlobalTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGlobalTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeGlobalTable$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeGlobalTableSettingsResponse describeGlobalTableSettings(DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest) throws GlobalTableNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTableSettings");
            DescribeGlobalTableSettingsResponse describeGlobalTableSettingsResponse = (DescribeGlobalTableSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTableSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeGlobalTableSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeGlobalTableSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeGlobalTableSettings$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeImportResponse describeImport(DescribeImportRequest describeImportRequest) throws ImportNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImport");
            DescribeImportResponse describeImportResponse = (DescribeImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeImport$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeKinesisStreamingDestinationResponse describeKinesisStreamingDestination(DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKinesisStreamingDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKinesisStreamingDestination");
            DescribeKinesisStreamingDestinationResponse describeKinesisStreamingDestinationResponse = (DescribeKinesisStreamingDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKinesisStreamingDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeKinesisStreamingDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeKinesisStreamingDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeKinesisStreamingDestination$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeLimitsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeLimitsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeLimitsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLimits");
            DescribeLimitsResponse describeLimitsResponse = (DescribeLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeLimits$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            DescribeTableResponse describeTableResponse = (DescribeTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeTable$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableReplicaAutoScalingResponse describeTableReplicaAutoScaling(DescribeTableReplicaAutoScalingRequest describeTableReplicaAutoScalingRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableReplicaAutoScalingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableReplicaAutoScaling");
            DescribeTableReplicaAutoScalingResponse describeTableReplicaAutoScalingResponse = (DescribeTableReplicaAutoScalingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableReplicaAutoScaling").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTableReplicaAutoScalingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableReplicaAutoScalingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeTableReplicaAutoScaling$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTimeToLiveResponse describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTimeToLiveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = describeTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, describeTimeToLiveRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTimeToLive");
            DescribeTimeToLiveResponse describeTimeToLiveResponse = (DescribeTimeToLiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTimeToLive").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTimeToLiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTimeToLiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$describeTimeToLive$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableKinesisStreamingDestinationResponse disableKinesisStreamingDestination(DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest) throws InternalServerErrorException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKinesisStreamingDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = disableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKinesisStreamingDestination");
            DisableKinesisStreamingDestinationResponse disableKinesisStreamingDestinationResponse = (DisableKinesisStreamingDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKinesisStreamingDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)disableKinesisStreamingDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableKinesisStreamingDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$disableKinesisStreamingDestination$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableKinesisStreamingDestinationResponse enableKinesisStreamingDestination(EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest) throws InternalServerErrorException, LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKinesisStreamingDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = enableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKinesisStreamingDestination");
            EnableKinesisStreamingDestinationResponse enableKinesisStreamingDestinationResponse = (EnableKinesisStreamingDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKinesisStreamingDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)enableKinesisStreamingDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableKinesisStreamingDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$enableKinesisStreamingDestination$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteStatementResponse executeStatement(ExecuteStatementRequest executeStatementRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, DuplicateItemException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteStatementResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, executeStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteStatement");
            ExecuteStatementResponse executeStatementResponse = (ExecuteStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteStatement").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$executeStatement$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteTransactionResponse executeTransaction(ExecuteTransactionRequest executeTransactionRequest) throws ResourceNotFoundException, TransactionCanceledException, TransactionInProgressException, IdempotentParameterMismatchException, ProvisionedThroughputExceededException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteTransactionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, executeTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteTransaction");
            ExecuteTransactionResponse executeTransactionResponse = (ExecuteTransactionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteTransaction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)executeTransactionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeTransactionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$executeTransaction$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportTableToPointInTimeResponse exportTableToPointInTime(ExportTableToPointInTimeRequest exportTableToPointInTimeRequest) throws TableNotFoundException, PointInTimeRecoveryUnavailableException, LimitExceededException, InvalidExportTimeException, ExportConflictException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportTableToPointInTimeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, exportTableToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportTableToPointInTime");
            ExportTableToPointInTimeResponse exportTableToPointInTimeResponse = (ExportTableToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportTableToPointInTime").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportTableToPointInTimeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportTableToPointInTimeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$exportTableToPointInTime$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetItemResponse getItem(GetItemRequest getItemRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = getItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)getItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, getItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetItem");
            GetItemResponse getItemResponse = (GetItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)getItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$getItem$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportTableResponse importTable(ImportTableRequest importTableRequest) throws ResourceInUseException, LimitExceededException, ImportConflictException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, importTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportTable");
            ImportTableResponse importTableResponse = (ImportTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$importTable$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBackupsResponse listBackups(ListBackupsRequest listBackupsRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listBackupsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, listBackupsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBackups");
            ListBackupsResponse listBackupsResponse = (ListBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listBackups$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContributorInsightsResponse listContributorInsights(ListContributorInsightsRequest listContributorInsightsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContributorInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, listContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContributorInsights");
            ListContributorInsightsResponse listContributorInsightsResponse = (ListContributorInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContributorInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listContributorInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listContributorInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listContributorInsights$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListContributorInsightsIterable listContributorInsightsPaginator(ListContributorInsightsRequest listContributorInsightsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return new ListContributorInsightsIterable(this, this.applyPaginatorUserAgent(listContributorInsightsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, listExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExports");
            ListExportsResponse listExportsResponse = (ListExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listExports$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return new ListExportsIterable(this, this.applyPaginatorUserAgent(listExportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGlobalTablesResponse listGlobalTables(ListGlobalTablesRequest listGlobalTablesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGlobalTablesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listGlobalTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listGlobalTablesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, listGlobalTablesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGlobalTables");
            ListGlobalTablesResponse listGlobalTablesResponse = (ListGlobalTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGlobalTables").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listGlobalTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGlobalTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGlobalTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listGlobalTables$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            ListImportsResponse listImportsResponse = (ListImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listImportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listImports$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, DynamoDbException {
        return new ListImportsIterable(this, this.applyPaginatorUserAgent(listImportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTablesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            ListTablesResponse listTablesResponse = (ListTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listTables$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return new ListTablesIterable(this, this.applyPaginatorUserAgent(listTablesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsOfResourceResponse listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsOfResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = listTagsOfResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTagsOfResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, listTagsOfResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsOfResource");
            ListTagsOfResourceResponse listTagsOfResourceResponse = (ListTagsOfResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsOfResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsOfResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsOfResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsOfResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$listTagsOfResource$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutItemResponse putItem(PutItemRequest putItemRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = putItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)putItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, putItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutItem");
            PutItemResponse putItemResponse = (PutItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)putItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$putItem$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse query(QueryRequest queryRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = queryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)queryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, queryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            QueryResponse queryResponse = (QueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)queryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$query$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public QueryIterable queryPaginator(QueryRequest queryRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return new QueryIterable(this, this.applyPaginatorUserAgent(queryRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreTableFromBackupResponse restoreTableFromBackup(RestoreTableFromBackupRequest restoreTableFromBackupRequest) throws TableAlreadyExistsException, TableInUseException, BackupNotFoundException, BackupInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableFromBackupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = restoreTableFromBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)restoreTableFromBackupRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, restoreTableFromBackupRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableFromBackup");
            RestoreTableFromBackupResponse restoreTableFromBackupResponse = (RestoreTableFromBackupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromBackup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)restoreTableFromBackupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreTableFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreTableFromBackupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$restoreTableFromBackup$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreTableToPointInTimeResponse restoreTableToPointInTime(RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest) throws TableAlreadyExistsException, TableNotFoundException, TableInUseException, LimitExceededException, InvalidRestoreTimeException, PointInTimeRecoveryUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableToPointInTimeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = restoreTableToPointInTimeRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableToPointInTime");
            RestoreTableToPointInTimeResponse restoreTableToPointInTimeResponse = (RestoreTableToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableToPointInTime").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)restoreTableToPointInTimeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreTableToPointInTimeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$restoreTableToPointInTime$66((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResponse scan(ScanRequest scanRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ScanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = scanRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)scanRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, scanRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Scan");
            ScanResponse scanResponse = (ScanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Scan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)scanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return scanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$scan$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ScanIterable scanPaginator(ScanRequest scanRequest) throws ProvisionedThroughputExceededException, ResourceNotFoundException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return new ScanIterable(this, this.applyPaginatorUserAgent(scanRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException, ResourceNotFoundException, InternalServerErrorException, ResourceInUseException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$tagResource$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactGetItemsResponse transactGetItems(TransactGetItemsRequest transactGetItemsRequest) throws ResourceNotFoundException, TransactionCanceledException, ProvisionedThroughputExceededException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactGetItemsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = transactGetItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)transactGetItemsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, transactGetItemsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactGetItems");
            TransactGetItemsResponse transactGetItemsResponse = (TransactGetItemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactGetItems").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)transactGetItemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TransactGetItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return transactGetItemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$transactGetItems$72((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactWriteItemsResponse transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest) throws ResourceNotFoundException, TransactionCanceledException, TransactionInProgressException, IdempotentParameterMismatchException, ProvisionedThroughputExceededException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactWriteItemsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = transactWriteItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)transactWriteItemsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, transactWriteItemsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactWriteItems");
            TransactWriteItemsResponse transactWriteItemsResponse = (TransactWriteItemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactWriteItems").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)transactWriteItemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TransactWriteItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return transactWriteItemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$transactWriteItems$74((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws LimitExceededException, ResourceNotFoundException, InternalServerErrorException, ResourceInUseException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$untagResource$76((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContinuousBackupsResponse updateContinuousBackups(UpdateContinuousBackupsRequest updateContinuousBackupsRequest) throws TableNotFoundException, ContinuousBackupsUnavailableException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContinuousBackupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateContinuousBackupsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContinuousBackups");
            UpdateContinuousBackupsResponse updateContinuousBackupsResponse = (UpdateContinuousBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContinuousBackups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateContinuousBackupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContinuousBackupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateContinuousBackups$78((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContributorInsightsResponse updateContributorInsights(UpdateContributorInsightsRequest updateContributorInsightsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContributorInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContributorInsights");
            UpdateContributorInsightsResponse updateContributorInsightsResponse = (UpdateContributorInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContributorInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateContributorInsightsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateContributorInsightsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateContributorInsights$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGlobalTableResponse updateGlobalTable(UpdateGlobalTableRequest updateGlobalTableRequest) throws InternalServerErrorException, GlobalTableNotFoundException, ReplicaAlreadyExistsException, ReplicaNotFoundException, TableNotFoundException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateGlobalTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTable");
            UpdateGlobalTableResponse updateGlobalTableResponse = (UpdateGlobalTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateGlobalTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGlobalTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateGlobalTable$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGlobalTableSettingsResponse updateGlobalTableSettings(UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) throws GlobalTableNotFoundException, ReplicaNotFoundException, IndexNotFoundException, LimitExceededException, ResourceInUseException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTableSettings");
            UpdateGlobalTableSettingsResponse updateGlobalTableSettingsResponse = (UpdateGlobalTableSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTableSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateGlobalTableSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGlobalTableSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateGlobalTableSettings$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateItemResponse updateItem(UpdateItemRequest updateItemRequest) throws ConditionalCheckFailedException, ProvisionedThroughputExceededException, ResourceNotFoundException, ItemCollectionSizeLimitExceededException, TransactionConflictException, RequestLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateItemRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateItemRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateItem");
            UpdateItemResponse updateItemResponse = (UpdateItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateItem$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateTableRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            UpdateTableResponse updateTableResponse = (UpdateTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateTable$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTableReplicaAutoScalingResponse updateTableReplicaAutoScaling(UpdateTableReplicaAutoScalingRequest updateTableReplicaAutoScalingRequest) throws ResourceNotFoundException, ResourceInUseException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableReplicaAutoScalingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableReplicaAutoScaling");
            UpdateTableReplicaAutoScalingResponse updateTableReplicaAutoScalingResponse = (UpdateTableReplicaAutoScalingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableReplicaAutoScaling").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTableReplicaAutoScalingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTableReplicaAutoScalingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateTableReplicaAutoScaling$88((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTimeToLiveResponse updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest) throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTimeToLiveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            String key = updateTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultDynamoDbClient.resolveMetricPublishers(this.clientConfiguration, updateTimeToLiveRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTimeToLive");
            UpdateTimeToLiveResponse updateTimeToLiveResponse = (UpdateTimeToLiveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTimeToLive").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTimeToLiveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTimeToLiveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbClient.lambda$updateTimeToLive$90((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DynamoDbWaiter waiter() {
        return DynamoDbWaiter.builder().client(this).build();
    }

    private <T extends DynamoDbRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.22").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DynamoDbRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "dynamodb";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DynamoDbException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").exceptionBuilderSupplier(RequestLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImportConflictException").exceptionBuilderSupplier(ImportConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").exceptionBuilderSupplier(ConditionalCheckFailedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").exceptionBuilderSupplier(GlobalTableNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").exceptionBuilderSupplier(ReplicaNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupInUseException").exceptionBuilderSupplier(BackupInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExportNotFoundException").exceptionBuilderSupplier(ExportNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionInProgressException").exceptionBuilderSupplier(TransactionInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableInUseException").exceptionBuilderSupplier(TableInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").exceptionBuilderSupplier(TableAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExportConflictException").exceptionBuilderSupplier(ExportConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionConflictException").exceptionBuilderSupplier(TransactionConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").exceptionBuilderSupplier(InvalidRestoreTimeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupNotFoundException").exceptionBuilderSupplier(BackupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IndexNotFoundException").exceptionBuilderSupplier(IndexNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableNotFoundException").exceptionBuilderSupplier(TableNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateItemException").exceptionBuilderSupplier(DuplicateItemException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImportNotFoundException").exceptionBuilderSupplier(ImportNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionCanceledException").exceptionBuilderSupplier(TransactionCanceledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").exceptionBuilderSupplier(InvalidExportTimeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTimeToLive$90(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTableReplicaAutoScaling$88(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateItem$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTableSettings$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTable$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContributorInsights$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContinuousBackups$78(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$76(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactWriteItems$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactGetItems$72(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$scan$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableToPointInTime$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableFromBackup$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putItem$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsOfResource$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImports$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGlobalTables$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExports$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContributorInsights$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBackups$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importTable$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getItem$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportTableToPointInTime$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeTransaction$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeStatement$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKinesisStreamingDestination$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKinesisStreamingDestination$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTimeToLive$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTableReplicaAutoScaling$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLimits$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKinesisStreamingDestination$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImport$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTableSettings$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTable$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExport$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContributorInsights$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContinuousBackups$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackup$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteItem$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGlobalTable$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackup$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchWriteItem$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetItem$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchExecuteStatement$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

