/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a replica global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaGlobalSecondaryIndex implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaGlobalSecondaryIndex.Builder, ReplicaGlobalSecondaryIndex> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(ReplicaGlobalSecondaryIndex::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField
            .<ProvisionedThroughputOverride> builder(MarshallingType.SDK_POJO)
            .memberName("ProvisionedThroughputOverride")
            .getter(getter(ReplicaGlobalSecondaryIndex::provisionedThroughputOverride))
            .setter(setter(Builder::provisionedThroughputOverride))
            .constructor(ProvisionedThroughputOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            PROVISIONED_THROUGHPUT_OVERRIDE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final ProvisionedThroughputOverride provisionedThroughputOverride;

    private ReplicaGlobalSecondaryIndex(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
    }

    /**
     * <p>
     * The name of the global secondary index.
     * </p>
     * 
     * @return The name of the global secondary index.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read capacity
     * settings.
     * </p>
     * 
     * @return Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read
     *         capacity settings.
     */
    public final ProvisionedThroughputOverride provisionedThroughputOverride() {
        return provisionedThroughputOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaGlobalSecondaryIndex)) {
            return false;
        }
        ReplicaGlobalSecondaryIndex other = (ReplicaGlobalSecondaryIndex) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(provisionedThroughputOverride(), other.provisionedThroughputOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaGlobalSecondaryIndex").add("IndexName", indexName())
                .add("ProvisionedThroughputOverride", provisionedThroughputOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ProvisionedThroughputOverride":
            return Optional.ofNullable(clazz.cast(provisionedThroughputOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaGlobalSecondaryIndex, T> g) {
        return obj -> g.apply((ReplicaGlobalSecondaryIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaGlobalSecondaryIndex> {
        /**
         * <p>
         * The name of the global secondary index.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read
         * capacity settings.
         * </p>
         * 
         * @param provisionedThroughputOverride
         *        Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read
         *        capacity settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride);

        /**
         * <p>
         * Replica table GSI-specific provisioned throughput. If not specified, uses the source table GSI's read
         * capacity settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughputOverride.Builder}
         * avoiding the need to create one manually via {@link ProvisionedThroughputOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedThroughputOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedThroughputOverride(ProvisionedThroughputOverride)}.
         * 
         * @param provisionedThroughputOverride
         *        a consumer that will call methods on {@link ProvisionedThroughputOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughputOverride(ProvisionedThroughputOverride)
         */
        default Builder provisionedThroughputOverride(
                Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return provisionedThroughputOverride(ProvisionedThroughputOverride.builder()
                    .applyMutation(provisionedThroughputOverride).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private ProvisionedThroughputOverride provisionedThroughputOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaGlobalSecondaryIndex model) {
            indexName(model.indexName);
            provisionedThroughputOverride(model.provisionedThroughputOverride);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return provisionedThroughputOverride != null ? provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build()
                    : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        @Override
        public ReplicaGlobalSecondaryIndex build() {
            return new ReplicaGlobalSecondaryIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
