/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PointInTimeRecoveryDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PointInTimeRecoveryDescription> {
    private static final SdkField<String> POINT_IN_TIME_RECOVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PointInTimeRecoveryDescription.getter(PointInTimeRecoveryDescription::pointInTimeRecoveryStatusAsString)).setter(PointInTimeRecoveryDescription.setter(Builder::pointInTimeRecoveryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointInTimeRecoveryStatus").build()}).build();
    private static final SdkField<Instant> EARLIEST_RESTORABLE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PointInTimeRecoveryDescription.getter(PointInTimeRecoveryDescription::earliestRestorableDateTime)).setter(PointInTimeRecoveryDescription.setter(Builder::earliestRestorableDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestRestorableDateTime").build()}).build();
    private static final SdkField<Instant> LATEST_RESTORABLE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PointInTimeRecoveryDescription.getter(PointInTimeRecoveryDescription::latestRestorableDateTime)).setter(PointInTimeRecoveryDescription.setter(Builder::latestRestorableDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POINT_IN_TIME_RECOVERY_STATUS_FIELD, EARLIEST_RESTORABLE_DATE_TIME_FIELD, LATEST_RESTORABLE_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pointInTimeRecoveryStatus;
    private final Instant earliestRestorableDateTime;
    private final Instant latestRestorableDateTime;

    private PointInTimeRecoveryDescription(BuilderImpl builder) {
        this.pointInTimeRecoveryStatus = builder.pointInTimeRecoveryStatus;
        this.earliestRestorableDateTime = builder.earliestRestorableDateTime;
        this.latestRestorableDateTime = builder.latestRestorableDateTime;
    }

    public PointInTimeRecoveryStatus pointInTimeRecoveryStatus() {
        return PointInTimeRecoveryStatus.fromValue(this.pointInTimeRecoveryStatus);
    }

    public String pointInTimeRecoveryStatusAsString() {
        return this.pointInTimeRecoveryStatus;
    }

    public Instant earliestRestorableDateTime() {
        return this.earliestRestorableDateTime;
    }

    public Instant latestRestorableDateTime() {
        return this.latestRestorableDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeRecoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.earliestRestorableDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRestorableDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoveryDescription)) {
            return false;
        }
        PointInTimeRecoveryDescription other = (PointInTimeRecoveryDescription)obj;
        return Objects.equals(this.pointInTimeRecoveryStatusAsString(), other.pointInTimeRecoveryStatusAsString()) && Objects.equals(this.earliestRestorableDateTime(), other.earliestRestorableDateTime()) && Objects.equals(this.latestRestorableDateTime(), other.latestRestorableDateTime());
    }

    public String toString() {
        return ToString.builder((String)"PointInTimeRecoveryDescription").add("PointInTimeRecoveryStatus", (Object)this.pointInTimeRecoveryStatusAsString()).add("EarliestRestorableDateTime", (Object)this.earliestRestorableDateTime()).add("LatestRestorableDateTime", (Object)this.latestRestorableDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PointInTimeRecoveryStatus": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeRecoveryStatusAsString()));
            }
            case "EarliestRestorableDateTime": {
                return Optional.ofNullable(clazz.cast(this.earliestRestorableDateTime()));
            }
            case "LatestRestorableDateTime": {
                return Optional.ofNullable(clazz.cast(this.latestRestorableDateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PointInTimeRecoveryDescription, T> g) {
        return obj -> g.apply((PointInTimeRecoveryDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pointInTimeRecoveryStatus;
        private Instant earliestRestorableDateTime;
        private Instant latestRestorableDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoveryDescription model) {
            this.pointInTimeRecoveryStatus(model.pointInTimeRecoveryStatus);
            this.earliestRestorableDateTime(model.earliestRestorableDateTime);
            this.latestRestorableDateTime(model.latestRestorableDateTime);
        }

        public final String getPointInTimeRecoveryStatus() {
            return this.pointInTimeRecoveryStatus;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
            return this;
        }

        @Override
        public final Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus(pointInTimeRecoveryStatus.toString());
            return this;
        }

        public final void setPointInTimeRecoveryStatus(String pointInTimeRecoveryStatus) {
            this.pointInTimeRecoveryStatus = pointInTimeRecoveryStatus;
        }

        public final Instant getEarliestRestorableDateTime() {
            return this.earliestRestorableDateTime;
        }

        @Override
        public final Builder earliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
            return this;
        }

        public final void setEarliestRestorableDateTime(Instant earliestRestorableDateTime) {
            this.earliestRestorableDateTime = earliestRestorableDateTime;
        }

        public final Instant getLatestRestorableDateTime() {
            return this.latestRestorableDateTime;
        }

        @Override
        public final Builder latestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
            return this;
        }

        public final void setLatestRestorableDateTime(Instant latestRestorableDateTime) {
            this.latestRestorableDateTime = latestRestorableDateTime;
        }

        public PointInTimeRecoveryDescription build() {
            return new PointInTimeRecoveryDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PointInTimeRecoveryDescription> {
        public Builder pointInTimeRecoveryStatus(String var1);

        public Builder pointInTimeRecoveryStatus(PointInTimeRecoveryStatus var1);

        public Builder earliestRestorableDateTime(Instant var1);

        public Builder latestRestorableDateTime(Instant var1);
    }
}

