/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an item and related attribute values to retrieve in a <code>TransactGetItem</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Get implements SdkPojo, Serializable, ToCopyableBuilder<Get.Builder, Get> {
    private static final SdkField<Map<String, AttributeValue>> KEY_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("Key")
            .getter(getter(Get::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(Get::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectionExpression").getter(getter(Get::projectionExpression))
            .setter(setter(Builder::projectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ExpressionAttributeNames")
            .getter(getter(Get::expressionAttributeNames))
            .setter(setter(Builder::expressionAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, TABLE_NAME_FIELD,
            PROJECTION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, AttributeValue> key;

    private final String tableName;

    private final String projectionExpression;

    private final Map<String, String> expressionAttributeNames;

    private Get(BuilderImpl builder) {
        this.key = builder.key;
        this.tableName = builder.tableName;
        this.projectionExpression = builder.projectionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the Key property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKey() {
        return key != null && !(key instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the item to
     * retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKey} method.
     * </p>
     * 
     * @return A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the
     *         item to retrieve.
     */
    public final Map<String, AttributeValue> key() {
        return key;
    }

    /**
     * <p>
     * The name of the table from which to retrieve the specified item.
     * </p>
     * 
     * @return The name of the table from which to retrieve the specified item.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A string that identifies one or more attributes of the specified item to retrieve from the table. The attributes
     * in the expression must be separated by commas. If no attribute names are specified, then all attributes of the
     * specified item are returned. If any of the requested attributes are not found, they do not appear in the result.
     * </p>
     * 
     * @return A string that identifies one or more attributes of the specified item to retrieve from the table. The
     *         attributes in the expression must be separated by commas. If no attribute names are specified, then all
     *         attributes of the specified item are returned. If any of the requested attributes are not found, they do
     *         not appear in the result.
     */
    public final String projectionExpression() {
        return projectionExpression;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExpressionAttributeNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExpressionAttributeNames() {
        return expressionAttributeNames != null && !(expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in the ProjectionExpression parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExpressionAttributeNames} method.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in the ProjectionExpression parameter.
     */
    public final Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKey() ? key() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpressionAttributeNames() ? expressionAttributeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Get)) {
            return false;
        }
        Get other = (Get) obj;
        return hasKey() == other.hasKey() && Objects.equals(key(), other.key()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(projectionExpression(), other.projectionExpression())
                && hasExpressionAttributeNames() == other.hasExpressionAttributeNames()
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Get").add("Key", hasKey() ? key() : null).add("TableName", tableName())
                .add("ProjectionExpression", projectionExpression())
                .add("ExpressionAttributeNames", hasExpressionAttributeNames() ? expressionAttributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "ProjectionExpression":
            return Optional.ofNullable(clazz.cast(projectionExpression()));
        case "ExpressionAttributeNames":
            return Optional.ofNullable(clazz.cast(expressionAttributeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Get, T> g) {
        return obj -> g.apply((Get) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Get> {
        /**
         * <p>
         * A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the item to
         * retrieve.
         * </p>
         * 
         * @param key
         *        A map of attribute names to <code>AttributeValue</code> objects that specifies the primary key of the
         *        item to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Map<String, AttributeValue> key);

        /**
         * <p>
         * The name of the table from which to retrieve the specified item.
         * </p>
         * 
         * @param tableName
         *        The name of the table from which to retrieve the specified item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A string that identifies one or more attributes of the specified item to retrieve from the table. The
         * attributes in the expression must be separated by commas. If no attribute names are specified, then all
         * attributes of the specified item are returned. If any of the requested attributes are not found, they do not
         * appear in the result.
         * </p>
         * 
         * @param projectionExpression
         *        A string that identifies one or more attributes of the specified item to retrieve from the table. The
         *        attributes in the expression must be separated by commas. If no attribute names are specified, then
         *        all attributes of the specified item are returned. If any of the requested attributes are not found,
         *        they do not appear in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectionExpression(String projectionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in the ProjectionExpression parameter.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in the ProjectionExpression parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, AttributeValue> key = DefaultSdkAutoConstructMap.getInstance();

        private String tableName;

        private String projectionExpression;

        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Get model) {
            key(model.key);
            tableName(model.tableName);
            projectionExpression(model.projectionExpression);
            expressionAttributeNames(model.expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            Map<String, AttributeValue.Builder> result = KeyCopier.copyToBuilder(this.key);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        @Override
        @Transient
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getProjectionExpression() {
            return projectionExpression;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        @Override
        @Transient
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            if (expressionAttributeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return expressionAttributeNames;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        @Override
        @Transient
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        @Override
        public Get build() {
            return new Get(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
