/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the auto scaling settings of a replica that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaAutoScalingUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaAutoScalingUpdate.Builder, ReplicaAutoScalingUpdate> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ReplicaAutoScalingUpdate::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<List<ReplicaGlobalSecondaryIndexAutoScalingUpdate>> REPLICA_GLOBAL_SECONDARY_INDEX_UPDATES_FIELD = SdkField
            .<List<ReplicaGlobalSecondaryIndexAutoScalingUpdate>> builder(MarshallingType.LIST)
            .memberName("ReplicaGlobalSecondaryIndexUpdates")
            .getter(getter(ReplicaAutoScalingUpdate::replicaGlobalSecondaryIndexUpdates))
            .setter(setter(Builder::replicaGlobalSecondaryIndexUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaGlobalSecondaryIndexUpdates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaGlobalSecondaryIndexAutoScalingUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaGlobalSecondaryIndexAutoScalingUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoScalingSettingsUpdate> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_UPDATE_FIELD = SdkField
            .<AutoScalingSettingsUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicaProvisionedReadCapacityAutoScalingUpdate")
            .getter(getter(ReplicaAutoScalingUpdate::replicaProvisionedReadCapacityAutoScalingUpdate))
            .setter(setter(Builder::replicaProvisionedReadCapacityAutoScalingUpdate))
            .constructor(AutoScalingSettingsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedReadCapacityAutoScalingUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            REPLICA_GLOBAL_SECONDARY_INDEX_UPDATES_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final List<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates;

    private final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate;

    private ReplicaAutoScalingUpdate(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaGlobalSecondaryIndexUpdates = builder.replicaGlobalSecondaryIndexUpdates;
        this.replicaProvisionedReadCapacityAutoScalingUpdate = builder.replicaProvisionedReadCapacityAutoScalingUpdate;
    }

    /**
     * <p>
     * The Region where the replica exists.
     * </p>
     * 
     * @return The Region where the replica exists.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicaGlobalSecondaryIndexUpdates
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicaGlobalSecondaryIndexUpdates() {
        return replicaGlobalSecondaryIndexUpdates != null
                && !(replicaGlobalSecondaryIndexUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the auto scaling settings of global secondary indexes that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicaGlobalSecondaryIndexUpdates}
     * method.
     * </p>
     * 
     * @return Represents the auto scaling settings of global secondary indexes that will be modified.
     */
    public final List<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates() {
        return replicaGlobalSecondaryIndexUpdates;
    }

    /**
     * Returns the value of the ReplicaProvisionedReadCapacityAutoScalingUpdate property for this object.
     * 
     * @return The value of the ReplicaProvisionedReadCapacityAutoScalingUpdate property for this object.
     */
    public final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate() {
        return replicaProvisionedReadCapacityAutoScalingUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicaGlobalSecondaryIndexUpdates() ? replicaGlobalSecondaryIndexUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityAutoScalingUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaAutoScalingUpdate)) {
            return false;
        }
        ReplicaAutoScalingUpdate other = (ReplicaAutoScalingUpdate) obj;
        return Objects.equals(regionName(), other.regionName())
                && hasReplicaGlobalSecondaryIndexUpdates() == other.hasReplicaGlobalSecondaryIndexUpdates()
                && Objects.equals(replicaGlobalSecondaryIndexUpdates(), other.replicaGlobalSecondaryIndexUpdates())
                && Objects.equals(replicaProvisionedReadCapacityAutoScalingUpdate(),
                        other.replicaProvisionedReadCapacityAutoScalingUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ReplicaAutoScalingUpdate")
                .add("RegionName", regionName())
                .add("ReplicaGlobalSecondaryIndexUpdates",
                        hasReplicaGlobalSecondaryIndexUpdates() ? replicaGlobalSecondaryIndexUpdates() : null)
                .add("ReplicaProvisionedReadCapacityAutoScalingUpdate", replicaProvisionedReadCapacityAutoScalingUpdate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "ReplicaGlobalSecondaryIndexUpdates":
            return Optional.ofNullable(clazz.cast(replicaGlobalSecondaryIndexUpdates()));
        case "ReplicaProvisionedReadCapacityAutoScalingUpdate":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityAutoScalingUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaAutoScalingUpdate, T> g) {
        return obj -> g.apply((ReplicaAutoScalingUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaAutoScalingUpdate> {
        /**
         * <p>
         * The Region where the replica exists.
         * </p>
         * 
         * @param regionName
         *        The Region where the replica exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * Represents the auto scaling settings of global secondary indexes that will be modified.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexUpdates
         *        Represents the auto scaling settings of global secondary indexes that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexUpdates(
                Collection<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates);

        /**
         * <p>
         * Represents the auto scaling settings of global secondary indexes that will be modified.
         * </p>
         * 
         * @param replicaGlobalSecondaryIndexUpdates
         *        Represents the auto scaling settings of global secondary indexes that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaGlobalSecondaryIndexUpdates(
                ReplicaGlobalSecondaryIndexAutoScalingUpdate... replicaGlobalSecondaryIndexUpdates);

        /**
         * <p>
         * Represents the auto scaling settings of global secondary indexes that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndexAutoScalingUpdate>.Builder} avoiding the need to create one manually via
         * {@link List<ReplicaGlobalSecondaryIndexAutoScalingUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <ReplicaGlobalSecondaryIndexAutoScalingUpdate>.Builder#build()} is called immediately and its result is
         * passed to {@link #replicaGlobalSecondaryIndexUpdates(List<ReplicaGlobalSecondaryIndexAutoScalingUpdate>)}.
         * 
         * @param replicaGlobalSecondaryIndexUpdates
         *        a consumer that will call methods on {@link List
         *        <ReplicaGlobalSecondaryIndexAutoScalingUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaGlobalSecondaryIndexUpdates(List<ReplicaGlobalSecondaryIndexAutoScalingUpdate>)
         */
        Builder replicaGlobalSecondaryIndexUpdates(
                Consumer<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder>... replicaGlobalSecondaryIndexUpdates);

        /**
         * Sets the value of the ReplicaProvisionedReadCapacityAutoScalingUpdate property for this object.
         *
         * @param replicaProvisionedReadCapacityAutoScalingUpdate
         *        The new value for the ReplicaProvisionedReadCapacityAutoScalingUpdate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityAutoScalingUpdate(
                AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate);

        /**
         * Sets the value of the ReplicaProvisionedReadCapacityAutoScalingUpdate property for this object.
         *
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsUpdate.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #replicaProvisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param replicaProvisionedReadCapacityAutoScalingUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaProvisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate)
         */
        default Builder replicaProvisionedReadCapacityAutoScalingUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> replicaProvisionedReadCapacityAutoScalingUpdate) {
            return replicaProvisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(replicaProvisionedReadCapacityAutoScalingUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private List<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates = DefaultSdkAutoConstructList
                .getInstance();

        private AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaAutoScalingUpdate model) {
            regionName(model.regionName);
            replicaGlobalSecondaryIndexUpdates(model.replicaGlobalSecondaryIndexUpdates);
            replicaProvisionedReadCapacityAutoScalingUpdate(model.replicaProvisionedReadCapacityAutoScalingUpdate);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        @Transient
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder> getReplicaGlobalSecondaryIndexUpdates() {
            List<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder> result = ReplicaGlobalSecondaryIndexAutoScalingUpdateListCopier
                    .copyToBuilder(this.replicaGlobalSecondaryIndexUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaGlobalSecondaryIndexUpdates(
                Collection<ReplicaGlobalSecondaryIndexAutoScalingUpdate.BuilderImpl> replicaGlobalSecondaryIndexUpdates) {
            this.replicaGlobalSecondaryIndexUpdates = ReplicaGlobalSecondaryIndexAutoScalingUpdateListCopier
                    .copyFromBuilder(replicaGlobalSecondaryIndexUpdates);
        }

        @Override
        @Transient
        public final Builder replicaGlobalSecondaryIndexUpdates(
                Collection<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates) {
            this.replicaGlobalSecondaryIndexUpdates = ReplicaGlobalSecondaryIndexAutoScalingUpdateListCopier
                    .copy(replicaGlobalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexUpdates(
                ReplicaGlobalSecondaryIndexAutoScalingUpdate... replicaGlobalSecondaryIndexUpdates) {
            replicaGlobalSecondaryIndexUpdates(Arrays.asList(replicaGlobalSecondaryIndexUpdates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexUpdates(
                Consumer<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder>... replicaGlobalSecondaryIndexUpdates) {
            replicaGlobalSecondaryIndexUpdates(Stream.of(replicaGlobalSecondaryIndexUpdates)
                    .map(c -> ReplicaGlobalSecondaryIndexAutoScalingUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AutoScalingSettingsUpdate.Builder getReplicaProvisionedReadCapacityAutoScalingUpdate() {
            return replicaProvisionedReadCapacityAutoScalingUpdate != null ? replicaProvisionedReadCapacityAutoScalingUpdate
                    .toBuilder() : null;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingUpdate(
                AutoScalingSettingsUpdate.BuilderImpl replicaProvisionedReadCapacityAutoScalingUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingUpdate = replicaProvisionedReadCapacityAutoScalingUpdate != null ? replicaProvisionedReadCapacityAutoScalingUpdate
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder replicaProvisionedReadCapacityAutoScalingUpdate(
                AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingUpdate = replicaProvisionedReadCapacityAutoScalingUpdate;
            return this;
        }

        @Override
        public ReplicaAutoScalingUpdate build() {
            return new ReplicaAutoScalingUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
