/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class GlobalSecondaryIndexDescriptionListCopier {
    static List<GlobalSecondaryIndexDescription> copy(
            Collection<? extends GlobalSecondaryIndexDescription> globalSecondaryIndexDescriptionListParam) {
        List<GlobalSecondaryIndexDescription> list;
        if (globalSecondaryIndexDescriptionListParam == null
                || globalSecondaryIndexDescriptionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GlobalSecondaryIndexDescription> modifiableList = new ArrayList<>();
            globalSecondaryIndexDescriptionListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GlobalSecondaryIndexDescription> copyFromBuilder(
            Collection<? extends GlobalSecondaryIndexDescription.Builder> globalSecondaryIndexDescriptionListParam) {
        List<GlobalSecondaryIndexDescription> list;
        if (globalSecondaryIndexDescriptionListParam == null
                || globalSecondaryIndexDescriptionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GlobalSecondaryIndexDescription> modifiableList = new ArrayList<>();
            globalSecondaryIndexDescriptionListParam.forEach(entry -> {
                GlobalSecondaryIndexDescription member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GlobalSecondaryIndexDescription.Builder> copyToBuilder(
            Collection<? extends GlobalSecondaryIndexDescription> globalSecondaryIndexDescriptionListParam) {
        List<GlobalSecondaryIndexDescription.Builder> list;
        if (globalSecondaryIndexDescriptionListParam == null
                || globalSecondaryIndexDescriptionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GlobalSecondaryIndexDescription.Builder> modifiableList = new ArrayList<>();
            globalSecondaryIndexDescriptionListParam.forEach(entry -> {
                GlobalSecondaryIndexDescription.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
