/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings of a target tracking scaling policy that will be modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingTargetTrackingScalingPolicyConfigurationUpdate
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder, AutoScalingTargetTrackingScalingPolicyConfigurationUpdate> {
    private static final SdkField<Boolean> DISABLE_SCALE_IN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableScaleIn")
            .getter(getter(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate::disableScaleIn))
            .setter(setter(Builder::disableScaleIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableScaleIn").build()).build();

    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScaleInCooldown")
            .getter(getter(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate::scaleInCooldown))
            .setter(setter(Builder::scaleInCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInCooldown").build()).build();

    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScaleOutCooldown")
            .getter(getter(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate::scaleOutCooldown))
            .setter(setter(Builder::scaleOutCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleOutCooldown").build()).build();

    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("TargetValue").getter(getter(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate::targetValue))
            .setter(setter(Builder::targetValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_SCALE_IN_FIELD,
            SCALE_IN_COOLDOWN_FIELD, SCALE_OUT_COOLDOWN_FIELD, TARGET_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean disableScaleIn;

    private final Integer scaleInCooldown;

    private final Integer scaleOutCooldown;

    private final Double targetValue;

    private AutoScalingTargetTrackingScalingPolicyConfigurationUpdate(BuilderImpl builder) {
        this.disableScaleIn = builder.disableScaleIn;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.targetValue = builder.targetValue;
    }

    /**
     * <p>
     * Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is disabled
     * and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in is enabled
     * and the target tracking policy can remove capacity from the scalable resource. The default value is false.
     * </p>
     * 
     * @return Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is
     *         disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise,
     *         scale in is enabled and the target tracking policy can remove capacity from the scalable resource. The
     *         default value is false.
     */
    public final Boolean disableScaleIn() {
        return disableScaleIn;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
     * The cooldown period is used to block subsequent scale in requests until it has expired. You should scale in
     * conservatively to protect your application's availability. However, if another alarm triggers a scale out policy
     * during the cooldown period after a scale-in, application auto scaling scales out your scalable target
     * immediately.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scale in activity completes before another scale in activity can
     *         start. The cooldown period is used to block subsequent scale in requests until it has expired. You should
     *         scale in conservatively to protect your application's availability. However, if another alarm triggers a
     *         scale out policy during the cooldown period after a scale-in, application auto scaling scales out your
     *         scalable target immediately.
     */
    public final Integer scaleInCooldown() {
        return scaleInCooldown;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scale out activity completes before another scale out activity can start.
     * While the cooldown period is in effect, the capacity that has been added by the previous scale out event that
     * initiated the cooldown is calculated as part of the desired capacity for the next scale out. You should
     * continuously (but not excessively) scale out.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scale out activity completes before another scale out activity
     *         can start. While the cooldown period is in effect, the capacity that has been added by the previous scale
     *         out event that initiated the cooldown is calculated as part of the desired capacity for the next scale
     *         out. You should continuously (but not excessively) scale out.
     */
    public final Integer scaleOutCooldown() {
        return scaleOutCooldown;
    }

    /**
     * <p>
     * The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base
     * 2).
     * </p>
     * 
     * @return The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
     *         (Base 2).
     */
    public final Double targetValue() {
        return targetValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disableScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(targetValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)) {
            return false;
        }
        AutoScalingTargetTrackingScalingPolicyConfigurationUpdate other = (AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) obj;
        return Objects.equals(disableScaleIn(), other.disableScaleIn())
                && Objects.equals(scaleInCooldown(), other.scaleInCooldown())
                && Objects.equals(scaleOutCooldown(), other.scaleOutCooldown())
                && Objects.equals(targetValue(), other.targetValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingTargetTrackingScalingPolicyConfigurationUpdate")
                .add("DisableScaleIn", disableScaleIn()).add("ScaleInCooldown", scaleInCooldown())
                .add("ScaleOutCooldown", scaleOutCooldown()).add("TargetValue", targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisableScaleIn":
            return Optional.ofNullable(clazz.cast(disableScaleIn()));
        case "ScaleInCooldown":
            return Optional.ofNullable(clazz.cast(scaleInCooldown()));
        case "ScaleOutCooldown":
            return Optional.ofNullable(clazz.cast(scaleOutCooldown()));
        case "TargetValue":
            return Optional.ofNullable(clazz.cast(targetValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingTargetTrackingScalingPolicyConfigurationUpdate, T> g) {
        return obj -> g.apply((AutoScalingTargetTrackingScalingPolicyConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingTargetTrackingScalingPolicyConfigurationUpdate> {
        /**
         * <p>
         * Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in is
         * disabled and the target tracking policy won't remove capacity from the scalable resource. Otherwise, scale in
         * is enabled and the target tracking policy can remove capacity from the scalable resource. The default value
         * is false.
         * </p>
         * 
         * @param disableScaleIn
         *        Indicates whether scale in by the target tracking policy is disabled. If the value is true, scale in
         *        is disabled and the target tracking policy won't remove capacity from the scalable resource.
         *        Otherwise, scale in is enabled and the target tracking policy can remove capacity from the scalable
         *        resource. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableScaleIn(Boolean disableScaleIn);

        /**
         * <p>
         * The amount of time, in seconds, after a scale in activity completes before another scale in activity can
         * start. The cooldown period is used to block subsequent scale in requests until it has expired. You should
         * scale in conservatively to protect your application's availability. However, if another alarm triggers a
         * scale out policy during the cooldown period after a scale-in, application auto scaling scales out your
         * scalable target immediately.
         * </p>
         * 
         * @param scaleInCooldown
         *        The amount of time, in seconds, after a scale in activity completes before another scale in activity
         *        can start. The cooldown period is used to block subsequent scale in requests until it has expired. You
         *        should scale in conservatively to protect your application's availability. However, if another alarm
         *        triggers a scale out policy during the cooldown period after a scale-in, application auto scaling
         *        scales out your scalable target immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInCooldown(Integer scaleInCooldown);

        /**
         * <p>
         * The amount of time, in seconds, after a scale out activity completes before another scale out activity can
         * start. While the cooldown period is in effect, the capacity that has been added by the previous scale out
         * event that initiated the cooldown is calculated as part of the desired capacity for the next scale out. You
         * should continuously (but not excessively) scale out.
         * </p>
         * 
         * @param scaleOutCooldown
         *        The amount of time, in seconds, after a scale out activity completes before another scale out activity
         *        can start. While the cooldown period is in effect, the capacity that has been added by the previous
         *        scale out event that initiated the cooldown is calculated as part of the desired capacity for the next
         *        scale out. You should continuously (but not excessively) scale out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutCooldown(Integer scaleOutCooldown);

        /**
         * <p>
         * The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to 2e360
         * (Base 2).
         * </p>
         * 
         * @param targetValue
         *        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108 (Base 10) or 2e-360 to
         *        2e360 (Base 2).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetValue(Double targetValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disableScaleIn;

        private Integer scaleInCooldown;

        private Integer scaleOutCooldown;

        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate model) {
            disableScaleIn(model.disableScaleIn);
            scaleInCooldown(model.scaleInCooldown);
            scaleOutCooldown(model.scaleOutCooldown);
            targetValue(model.targetValue);
        }

        public final Boolean getDisableScaleIn() {
            return disableScaleIn;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        @Override
        @Transient
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final Integer getScaleInCooldown() {
            return scaleInCooldown;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        @Override
        @Transient
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final Integer getScaleOutCooldown() {
            return scaleOutCooldown;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        @Override
        @Transient
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final Double getTargetValue() {
            return targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        @Transient
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        @Override
        public AutoScalingTargetTrackingScalingPolicyConfigurationUpdate build() {
            return new AutoScalingTargetTrackingScalingPolicyConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
