/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StreamViewType {
    NEW_IMAGE("NEW_IMAGE"),
    OLD_IMAGE("OLD_IMAGE"),
    NEW_AND_OLD_IMAGES("NEW_AND_OLD_IMAGES"),
    KEYS_ONLY("KEYS_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StreamViewType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamViewType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StreamViewType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamViewType> knownValues() {
        return Stream.of(StreamViewType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

