/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContinuousBackupsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeContinuousBackupsResponse.Builder, DescribeContinuousBackupsResponse> {
    private static final SdkField<ContinuousBackupsDescription> CONTINUOUS_BACKUPS_DESCRIPTION_FIELD = SdkField
            .<ContinuousBackupsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ContinuousBackupsDescription")
            .getter(getter(DescribeContinuousBackupsResponse::continuousBackupsDescription))
            .setter(setter(Builder::continuousBackupsDescription))
            .constructor(ContinuousBackupsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousBackupsDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTINUOUS_BACKUPS_DESCRIPTION_FIELD));

    private final ContinuousBackupsDescription continuousBackupsDescription;

    private DescribeContinuousBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.continuousBackupsDescription = builder.continuousBackupsDescription;
    }

    /**
     * <p>
     * Represents the continuous backups and point in time recovery settings on the table.
     * </p>
     * 
     * @return Represents the continuous backups and point in time recovery settings on the table.
     */
    public final ContinuousBackupsDescription continuousBackupsDescription() {
        return continuousBackupsDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(continuousBackupsDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContinuousBackupsResponse)) {
            return false;
        }
        DescribeContinuousBackupsResponse other = (DescribeContinuousBackupsResponse) obj;
        return Objects.equals(continuousBackupsDescription(), other.continuousBackupsDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeContinuousBackupsResponse")
                .add("ContinuousBackupsDescription", continuousBackupsDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinuousBackupsDescription":
            return Optional.ofNullable(clazz.cast(continuousBackupsDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContinuousBackupsResponse, T> g) {
        return obj -> g.apply((DescribeContinuousBackupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeContinuousBackupsResponse> {
        /**
         * <p>
         * Represents the continuous backups and point in time recovery settings on the table.
         * </p>
         * 
         * @param continuousBackupsDescription
         *        Represents the continuous backups and point in time recovery settings on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousBackupsDescription(ContinuousBackupsDescription continuousBackupsDescription);

        /**
         * <p>
         * Represents the continuous backups and point in time recovery settings on the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContinuousBackupsDescription.Builder}
         * avoiding the need to create one manually via {@link ContinuousBackupsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContinuousBackupsDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #continuousBackupsDescription(ContinuousBackupsDescription)}.
         * 
         * @param continuousBackupsDescription
         *        a consumer that will call methods on {@link ContinuousBackupsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousBackupsDescription(ContinuousBackupsDescription)
         */
        default Builder continuousBackupsDescription(Consumer<ContinuousBackupsDescription.Builder> continuousBackupsDescription) {
            return continuousBackupsDescription(ContinuousBackupsDescription.builder()
                    .applyMutation(continuousBackupsDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private ContinuousBackupsDescription continuousBackupsDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContinuousBackupsResponse model) {
            super(model);
            continuousBackupsDescription(model.continuousBackupsDescription);
        }

        public final ContinuousBackupsDescription.Builder getContinuousBackupsDescription() {
            return continuousBackupsDescription != null ? continuousBackupsDescription.toBuilder() : null;
        }

        public final void setContinuousBackupsDescription(ContinuousBackupsDescription.BuilderImpl continuousBackupsDescription) {
            this.continuousBackupsDescription = continuousBackupsDescription != null ? continuousBackupsDescription.build()
                    : null;
        }

        @Override
        public final Builder continuousBackupsDescription(ContinuousBackupsDescription continuousBackupsDescription) {
            this.continuousBackupsDescription = continuousBackupsDescription;
            return this;
        }

        @Override
        public DescribeContinuousBackupsResponse build() {
            return new DescribeContinuousBackupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
