/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

final class KeyListCopier {
    KeyListCopier() {
    }

    static List<Map<String, AttributeValue>> copy(Collection<? extends Map<String, ? extends AttributeValue>> keyListParam) {
        Object list;
        if (keyListParam == null || keyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            keyListParam.forEach(entry -> {
                Object map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    LinkedHashMap modifiableMap = new LinkedHashMap();
                    entry.forEach((key, value) -> modifiableMap.put(key, value));
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, AttributeValue>> copyFromBuilder(Collection<? extends Map<String, ? extends AttributeValue.Builder>> keyListParam) {
        Object list;
        if (keyListParam == null || keyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            keyListParam.forEach(entry -> {
                Object map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    LinkedHashMap modifiableMap = new LinkedHashMap();
                    entry.forEach((key, value) -> {
                        AttributeValue member = value == null ? null : (AttributeValue)value.build();
                        modifiableMap.put(key, member);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, AttributeValue.Builder>> copyToBuilder(Collection<? extends Map<String, ? extends AttributeValue>> keyListParam) {
        Object list;
        if (keyListParam == null || keyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            keyListParam.forEach(entry -> {
                Object map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    LinkedHashMap modifiableMap = new LinkedHashMap();
                    entry.forEach((key, value) -> {
                        AttributeValue.Builder member = value == null ? null : value.toBuilder();
                        modifiableMap.put(key, member);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

